/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.api.v1.model.domain.Domain;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.helper.converter.DomainToNameConverter;
import de.malkusch.whoisServerList.compiler.merger.DomainMerger;
import de.malkusch.whoisServerList.compiler.merger.ListMerger;
import de.malkusch.whoisServerList.compiler.merger.NewestMerger;
import de.malkusch.whoisServerList.compiler.merger.NotNullMerger;
import de.malkusch.whoisServerList.compiler.merger.StringMerger;
import de.malkusch.whoisServerList.compiler.merger.URLMerger;
import java.net.URL;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TopLevelDomainMerger
extends DomainMerger<TopLevelDomain> {
    private final StringMerger countryCodeMerger = new StringMerger();
    private final URLMerger urlMerger;
    private final NotNullMerger<Domain.State> stateMerger = new NotNullMerger();
    private final ListMerger<Domain> subdomainMerger = new ListMerger<Domain>(new DomainToNameConverter(), new DomainMerger());

    public TopLevelDomainMerger(Properties properties) {
        this.urlMerger = new URLMerger(properties);
    }

    @Override
    protected void completeMerge(TopLevelDomain merged, TopLevelDomain left, TopLevelDomain right) throws InterruptedException {
        NewestMerger<URL> newestUrlMerger = new NewestMerger<URL>(left.getChanged(), right.getChanged(), this.urlMerger);
        merged.setRegistratonService(newestUrlMerger.merge(left.getRegistratonService(), right.getRegistratonService()));
        merged.setDomains(this.subdomainMerger.merge(left.getDomains(), right.getDomains()));
        NewestMerger<Domain.State> newestStateMerger = new NewestMerger<Domain.State>(left.getChanged(), right.getChanged(), this.stateMerger);
        merged.setState(newestStateMerger.merge(left.getState(), right.getState()));
        merged.setCountryCode(this.countryCodeMerger.merge(left.getCountryCode(), right.getCountryCode()));
    }
}

