/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

@NotThreadSafe
final class RedirectRecorder
extends DefaultRedirectStrategy {
    private URL redirectedLocation;
    private boolean temporaryRedirect = false;

    RedirectRecorder() {
    }

    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        try {
            URI location = super.getLocationURI(request, response, context);
            if (this.temporaryRedirect) {
                return location;
            }
            switch (response.getStatusLine().getStatusCode()) {
                case 301: {
                    this.redirectedLocation = location.toURL();
                    break;
                }
                case 302: 
                case 307: {
                    this.temporaryRedirect = true;
                    break;
                }
            }
            return location;
        }
        catch (MalformedURLException e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    URL getRedirectedLocation() {
        return this.redirectedLocation;
    }
}

