/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.api.v1.model.domain.Domain;
import de.malkusch.whoisServerList.compiler.helper.converter.WhoisServerToHostConverter;
import de.malkusch.whoisServerList.compiler.merger.DateMerger;
import de.malkusch.whoisServerList.compiler.merger.ListMerger;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import de.malkusch.whoisServerList.compiler.merger.StringMerger;
import de.malkusch.whoisServerList.compiler.merger.WhoisServerMerger;
import javax.annotation.concurrent.Immutable;

@Immutable
class DomainMerger<T extends Domain>
implements Merger<T> {
    private final ListMerger<WhoisServer> whoisListMerger = new ListMerger<WhoisServer>(new WhoisServerToHostConverter(), new WhoisServerMerger());
    private final DateMerger dateMerger = new DateMerger();
    private final StringMerger nameMerger = new StringMerger();

    DomainMerger() {
    }

    @Override
    public final T merge(T left, T right) throws InterruptedException {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Domain merged = (Domain)left.clone();
        merged.setName(this.nameMerger.merge(left.getName(), right.getName()));
        merged.setChanged(this.dateMerger.merge(left.getChanged(), right.getChanged()));
        merged.setCreated(this.dateMerger.merge(left.getCreated(), right.getCreated()));
        merged.setWhoisServers(this.whoisListMerger.merge(left.getWhoisServers(), right.getWhoisServers()));
        this.completeMerge(merged, left, right);
        return (T)merged;
    }

    protected void completeMerge(T merged, T left, T right) throws InterruptedException {
    }
}

