/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.helper.converter.DomainToNameConverter;
import de.malkusch.whoisServerList.compiler.merger.ConcurrentListMerger;
import de.malkusch.whoisServerList.compiler.merger.DateMerger;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import de.malkusch.whoisServerList.compiler.merger.StringMerger;
import de.malkusch.whoisServerList.compiler.merger.TopLevelDomainMerger;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DomainListMerger
implements Merger<DomainList> {
    private final StringMerger descriptionMerger = new StringMerger();
    private final StringMerger versionMerger = new StringMerger();
    private final DateMerger dateMerger = new DateMerger();
    private final ConcurrentListMerger<TopLevelDomain> domainsMerger;

    public DomainListMerger(Properties properties) {
        this.domainsMerger = new ConcurrentListMerger<TopLevelDomain>(new DomainToNameConverter(), new TopLevelDomainMerger(properties));
    }

    @Override
    public DomainList merge(DomainList left, DomainList right) throws InterruptedException {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        DomainList merged = left.clone();
        merged.setDate(this.dateMerger.merge(left.getDate(), right.getDate()));
        merged.setDescription(this.descriptionMerger.merge(left.getDescription(), right.getDescription()));
        merged.setDomains(this.domainsMerger.merge(left.getDomains(), right.getDomains()));
        merged.setVersion(this.versionMerger.merge(left.getVersion(), right.getVersion()));
        return merged;
    }
}

