/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.compiler.helper.ConcurrencyService;
import de.malkusch.whoisServerList.compiler.helper.converter.Converter;
import de.malkusch.whoisServerList.compiler.merger.AbstractListMerger;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConcurrentListMerger<T>
extends AbstractListMerger<T> {
    private final Executor executor = ConcurrencyService.getService().getExecutor();

    ConcurrentListMerger(Converter<? super T, ?> elementToIdConverter, Merger<T> elementMerger) {
        super(elementToIdConverter, elementMerger);
    }

    @Override
    List<T> mergeMaps(Map<Object, T> leftMap, Map<Object, T> rightMap) throws InterruptedException {
        final ConcurrentHashMap<Object, T> threadsafeRightMap = new ConcurrentHashMap<Object, T>(rightMap);
        ArrayList<FutureTask> tasks = new ArrayList<FutureTask>();
        for (final Map.Entry<Object, T> entry : leftMap.entrySet()) {
            FutureTask task = new FutureTask(new Callable<T>(){

                @Override
                public T call() throws InterruptedException {
                    Object right = threadsafeRightMap.remove(entry.getKey());
                    return ConcurrentListMerger.this.mergeElement(entry.getValue(), right);
                }
            });
            tasks.add(task);
            this.executor.execute(task);
        }
        ArrayList<Object> mergedList = new ArrayList<Object>();
        for (FutureTask task : tasks) {
            try {
                mergedList.add(task.get());
            }
            catch (ExecutionException e) {
                if (e.getCause() == null) {
                    throw new RuntimeException(e);
                }
                if (e.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
        mergedList.addAll(threadsafeRightMap.values());
        return mergedList;
    }
}

