/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.compiler.helper.converter.Converter;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class AbstractListMerger<T>
implements Merger<List<T>> {
    private final Converter<? super T, ?> elementToIdConverter;
    private final Merger<T> elementMerger;

    AbstractListMerger(Converter<? super T, ?> elementToIdConverter, Merger<T> elementMerger) {
        this.elementToIdConverter = elementToIdConverter;
        this.elementMerger = elementMerger;
    }

    @Override
    public final List<T> merge(List<T> left, List<T> right) throws InterruptedException {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return this.mergeMaps(this.mapCollection(left), this.mapCollection(right));
    }

    final T mergeElement(T left, T right) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.elementMerger.merge(left, right);
    }

    abstract List<T> mergeMaps(Map<Object, T> var1, Map<Object, T> var2) throws InterruptedException;

    private Map<Object, T> mapCollection(Collection<T> collection) {
        HashMap map = new HashMap();
        for (T item : collection) {
            map.put(this.elementToIdConverter.convert(item), item);
        }
        return map;
    }
}

