/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.xml;

import de.malkusch.whoisServerList.api.v0.model.Server;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.converter.Converter;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.WhoisServerBuilder;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
final class XMLServerToServerConverter
implements Converter<Server, WhoisServer> {
    XMLServerToServerConverter() {
    }

    @Override
    public WhoisServer convert(Server xmlServer) {
        WhoisServer server;
        WhoisServerBuilder factory = new WhoisServerBuilder(Source.XML);
        factory.setHost(xmlServer.getHost());
        try {
            server = (WhoisServer)factory.build();
        }
        catch (WhoisServerListException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        String xmlPattern = xmlServer.getAvailstring();
        if (xmlPattern != null) {
            Pattern pattern = Pattern.compile(Pattern.quote(xmlPattern), 2);
            server.setAvailablePattern(pattern);
        }
        return server;
    }
}

