/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.xml;

import de.malkusch.whoisServerList.api.v0.model.Domain;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.DomainUtil;
import de.malkusch.whoisServerList.compiler.helper.converter.Converter;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.DomainBuilder;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.TopLevelDomainBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class XMLDomainToDomainConverter
implements Converter<Domain, TopLevelDomain> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLDomainToDomainConverter.class);

    XMLDomainToDomainConverter() {
    }

    @Override
    public TopLevelDomain convert(Domain domain) {
        try {
            TopLevelDomainBuilder tldBuilder = new TopLevelDomainBuilder(Source.XML);
            tldBuilder.setName(domain.getName());
            TopLevelDomain tld = (TopLevelDomain)tldBuilder.build();
            if (!StringUtils.isEmpty((CharSequence)domain.getNic())) {
                try {
                    tld.setRegistratonService(new URL(domain.getNic()));
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("NIC {} for domain {} was invalid.", (Object)domain.getNic(), (Object)domain.getName());
                }
            }
            if (DomainUtil.isCountryCode(tld.getName())) {
                tld.setCountryCode(tld.getName().toUpperCase());
            }
            if (domain.getCountry() != null) {
                if (tld.getCountryCode() == null) {
                    LOGGER.warn("domain {} with country {} is no CCTLD.", (Object)domain.getName(), (Object)domain.getCountry());
                }
            } else if (tld.getCountryCode() != null) {
                LOGGER.warn("domain {} should have a country code.", (Object)domain.getName());
            }
            DomainBuilder<de.malkusch.whoisServerList.api.v1.model.domain.Domain> domainBuilder = new DomainBuilder<de.malkusch.whoisServerList.api.v1.model.domain.Domain>(Source.XML, de.malkusch.whoisServerList.api.v1.model.domain.Domain.class);
            for (Domain subdomain : domain.getDomain()) {
                domainBuilder.setName(subdomain.getName());
                tld.getDomains().add(domainBuilder.build());
            }
            return tld;
        }
        catch (WhoisServerListException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

