/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.xml;

import de.malkusch.whoisServerList.api.v0.ServerListFactory;
import de.malkusch.whoisServerList.api.v0.model.Domain;
import de.malkusch.whoisServerList.api.v0.model.Server;
import de.malkusch.whoisServerList.api.v0.model.Serverlist;
import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.helper.DomainUtil;
import de.malkusch.whoisServerList.compiler.list.DomainListFactory;
import de.malkusch.whoisServerList.compiler.list.exception.BuildListException;
import de.malkusch.whoisServerList.compiler.list.xml.XMLDomainToDomainConverter;
import de.malkusch.whoisServerList.compiler.list.xml.XMLServerToServerConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBException;

@NotThreadSafe
public final class XMLDomainListFactory
implements DomainListFactory {
    private final Map<String, TopLevelDomain> topLevelDomains = new HashMap<String, TopLevelDomain>();
    private final XMLDomainToDomainConverter domainConverter = new XMLDomainToDomainConverter();
    private final XMLServerToServerConverter serverConverter = new XMLServerToServerConverter();

    @Override
    public Source getSource() {
        return Source.XML;
    }

    @Override
    public DomainList buildList() throws BuildListException {
        try {
            this.topLevelDomains.clear();
            ServerListFactory factory = new ServerListFactory();
            Serverlist serverlist = factory.download();
            for (Server xmlServer : serverlist.getServer()) {
                if (xmlServer.getDomain().isEmpty()) continue;
                WhoisServer server = this.serverConverter.convert(xmlServer);
                for (Domain domain : xmlServer.getDomain()) {
                    TopLevelDomain tld = this.getTopLevelDomain(domain);
                    tld.getWhoisServers().add(server);
                }
            }
            DomainList list = new DomainList();
            list.setDomains(new ArrayList<TopLevelDomain>(this.topLevelDomains.values()));
            list.setVersion(this.parseVersion(serverlist.getNotes()));
            list.setDescription(this.parseDescription(serverlist.getNotes()));
            return list;
        }
        catch (JAXBException e) {
            throw new BuildListException(e);
        }
    }

    private String parseDescription(String notes) {
        Pattern pattern = Pattern.compile("(^.+?)\\s*Version:\\s[\\S]+", 32);
        Matcher matcher = pattern.matcher(notes);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1).trim();
    }

    private String parseVersion(String notes) {
        Pattern pattern = Pattern.compile("Version:\\s([\\S]+)");
        Matcher matcher = pattern.matcher(notes);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private TopLevelDomain getTopLevelDomain(Domain domain) {
        String name = DomainUtil.normalize(domain.getName());
        TopLevelDomain tld = this.topLevelDomains.get(name);
        if (tld == null) {
            tld = this.domainConverter.convert(domain);
            this.topLevelDomains.put(name, tld);
        }
        return tld;
    }
}

