/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.psl;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.domain.Domain;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.DomainUtil;
import de.malkusch.whoisServerList.compiler.list.DomainListFactory;
import de.malkusch.whoisServerList.compiler.list.exception.BuildListException;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.TopLevelDomainBuilder;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixListFactory;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public final class PublicSuffixDomainListFactory
implements DomainListFactory {
    private final Map<String, TopLevelDomain> topLevelDomains = new HashMap<String, TopLevelDomain>();
    private final TopLevelDomainBuilder tldBuilder = new TopLevelDomainBuilder(Source.PSL);
    private final PublicSuffixList suffixList;

    public PublicSuffixDomainListFactory(PublicSuffixList suffixList) {
        this.suffixList = suffixList;
    }

    public PublicSuffixDomainListFactory() {
        this(new PublicSuffixListFactory().build());
    }

    @Override
    public Source getSource() {
        return Source.PSL;
    }

    @Override
    public DomainList buildList() throws BuildListException, InterruptedException {
        this.topLevelDomains.clear();
        for (Rule rule : this.suffixList.getRules()) {
            if (rule.isExceptionRule() || rule.getPattern().contains("*")) continue;
            String name = DomainUtil.normalize(rule.getPattern());
            if (StringUtils.isEmpty((CharSequence)name)) {
                throw new BuildListException("Public Suffix List provided an empty rule");
            }
            String[] labels = de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil.splitLabels((String)name);
            TopLevelDomain topLevelDomain = this.getTopLevelDomain(labels[labels.length - 1]);
            if (ArrayUtils.getLength((Object)labels) <= 1) continue;
            Domain domain = new Domain();
            domain.setName(name);
            domain.setSource(this.getSource());
            topLevelDomain.getDomains().add(domain);
        }
        DomainList list = new DomainList();
        list.setDomains(new ArrayList<TopLevelDomain>(this.topLevelDomains.values()));
        return list;
    }

    private TopLevelDomain getTopLevelDomain(String name) throws InterruptedException {
        try {
            TopLevelDomain domain = this.topLevelDomains.get(name);
            if (domain == null) {
                this.tldBuilder.setName(name);
                domain = (TopLevelDomain)this.tldBuilder.build();
                this.topLevelDomains.put(name, domain);
            }
            return domain;
        }
        catch (WhoisServerListException e) {
            throw new RuntimeException(e);
        }
    }
}

