/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.listObjectBuilder;

import de.malkusch.whoisServerList.api.v1.model.ListObject;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class ListObjectBuilder<T extends ListObject<?>> {
    private final Source source;

    ListObjectBuilder(Source source) {
        this.source = source;
    }

    public final T build() throws WhoisServerListException, InterruptedException {
        try {
            ListObject object = (ListObject)this.getObjectType().newInstance();
            object.setSource(this.source);
            this.complete(object);
            return (T)object;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Class<? extends T> getObjectType();

    protected void complete(T object) throws WhoisServerListException, InterruptedException {
    }
}

