/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.iana;

import de.malkusch.whoisServerList.api.v1.model.domain.Domain;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.converter.InputStreamToBufferedReaderConverter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
final class Parser
implements Closeable {
    public static final String STATE_ACTIVE = "ACTIVE";
    public static final String STATE_INACTIVE = "INACTIVE";
    public static final String STATE_NEW = "NEW";
    private String[] keys;
    private final DateFormat dateFormat;
    private final Map<String, String> result = new HashMap<String, String>();
    private BufferedReader reader;
    private final List<URL> urls = new ArrayList<URL>();

    Parser() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    }

    void setKeys(String ... keys) {
        this.keys = keys;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    void parse(BufferedReader reader) throws IOException, InterruptedException {
        String line;
        this.reader = reader;
        String regex = String.format("^(%s):\\s+(\\S.*\\S)\\s*$", StringUtils.join((Object[])this.keys, (String)"|"));
        Pattern pattern = Pattern.compile(regex, 2);
        Pattern commentPattern = Pattern.compile("^% ");
        Pattern urlPattern = Pattern.compile("(https?://\\S+)(\\s|$)", 2);
        while ((line = reader.readLine()) != null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (commentPattern.matcher(line).find()) continue;
            Matcher urlMatcher = urlPattern.matcher(line);
            while (urlMatcher.find()) {
                this.urls.add(new URL(urlMatcher.group(1)));
            }
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            this.result.put(key, value);
        }
    }

    void parse(InputStream stream, Charset charset) throws IOException, InterruptedException {
        InputStreamToBufferedReaderConverter converter = new InputStreamToBufferedReaderConverter(charset);
        this.parse(converter.convert(stream));
    }

    String getString(String key) {
        return this.result.get(key);
    }

    Domain.State getState(String key) throws WhoisServerListException {
        String state = this.getString(key);
        if (state == null) {
            return null;
        }
        switch (state) {
            case "ACTIVE": {
                return Domain.State.ACTIVE;
            }
            case "NEW": {
                return Domain.State.NEW;
            }
            case "INACTIVE": {
                return Domain.State.INACTIVE;
            }
        }
        throw new WhoisServerListException(String.format("unexpected state %s", state));
    }

    Date getDate(String key) throws WhoisServerListException {
        try {
            String date = this.getString(key);
            if (date == null) {
                return null;
            }
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new WhoisServerListException(e);
        }
    }

    List<URL> getURLs() {
        return this.urls;
    }
}

