/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.iana;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.ConcurrencyService;
import de.malkusch.whoisServerList.compiler.helper.converter.DocumentToStringIteratorConvertor;
import de.malkusch.whoisServerList.compiler.helper.converter.EntityToDocumentConverter;
import de.malkusch.whoisServerList.compiler.list.DomainListFactory;
import de.malkusch.whoisServerList.compiler.list.exception.BuildListException;
import de.malkusch.whoisServerList.compiler.list.iana.IANATopLevelDomainBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

@Immutable
public final class IanaDomainListFactory
implements DomainListFactory {
    @PropertyKey
    public static final String PROPERTY_LIST_URI = "iana.list.uri";
    @PropertyKey
    public static final String PROPERTY_LIST_CHARSET = "iana.list.charset";
    @PropertyKey
    public static final String PROPERTY_LIST_TLD_XPATH = "iana.list.tld.xpath";
    @PropertyKey
    public static final String PROPERTY_WHOIS_HOST = "iana.whois.host";
    @PropertyKey
    public static final String PROPERTY_WHOIS_CHARSET = "iana.whois.charset";
    @PropertyKey
    public static final String PROPERTY_WHOIS_TIMEOUT_SECONDS = "iana.whois.timeout.seconds";
    private final Properties properties;

    public IanaDomainListFactory(Properties properties) {
        this.properties = properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DomainList buildList() throws BuildListException, InterruptedException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(this.properties.getProperty(PROPERTY_LIST_URI));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String charset = this.properties.getProperty(PROPERTY_LIST_CHARSET);
            EntityToDocumentConverter documentConverter = new EntityToDocumentConverter(charset);
            DocumentToStringIteratorConvertor<HttpEntity> tldConverter = new DocumentToStringIteratorConvertor<HttpEntity>(this.properties.getProperty(PROPERTY_LIST_TLD_XPATH), documentConverter);
            ConcurrencyService concurrencyService = ConcurrencyService.getService();
            ArrayList<FutureTask<TopLevelDomain>> tasks = new ArrayList<FutureTask<TopLevelDomain>>();
            Iterator i$ = tldConverter.convert((Object)entity).iterator();
            while (i$.hasNext()) {
                final String name = (String)i$.next();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                FutureTask<TopLevelDomain> task = new FutureTask<TopLevelDomain>(new Callable<TopLevelDomain>(){

                    @Override
                    public TopLevelDomain call() throws WhoisServerListException, InterruptedException {
                        IANATopLevelDomainBuilder builder = new IANATopLevelDomainBuilder(IanaDomainListFactory.this.properties);
                        builder.setName(name.replaceFirst("\\.", ""));
                        return (TopLevelDomain)builder.build();
                    }
                });
                tasks.add(task);
                concurrencyService.getExecutor().execute(task);
            }
            ArrayList domains = new ArrayList();
            int timeout = Integer.parseInt(this.properties.getProperty(PROPERTY_WHOIS_TIMEOUT_SECONDS));
            for (Future domainList : tasks) {
                domains.add(domainList.get(timeout, TimeUnit.SECONDS));
            }
            EntityUtils.consume((HttpEntity)entity);
            DomainList list = new DomainList();
            list.setDomains(domains);
            DomainList domainList = list;
            return domainList;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof InterruptedException)) throw new BuildListException(e);
            throw (InterruptedException)e.getCause();
        }
        catch (WhoisServerListException | IOException | TimeoutException e) {
            throw new BuildListException(e);
        }
    }

    @Override
    public Source getSource() {
        return Source.IANA;
    }
}

