/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.list.iana;

import de.malkusch.whoisServerList.api.v1.model.Source;
import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.list.exception.BuildDomainException;
import de.malkusch.whoisServerList.compiler.list.iana.Parser;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.TopLevelDomainBuilder;
import de.malkusch.whoisServerList.compiler.list.listObjectBuilder.WhoisServerBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.net.whois.WhoisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class IANATopLevelDomainBuilder
extends TopLevelDomainBuilder {
    public static final String KEY_WHOIS = "whois";
    public static final String KEY_CREATED = "created";
    public static final String KEY_CHANGED = "changed";
    public static final String KEY_STATE = "status";
    private final Properties properties;
    private final WhoisServerBuilder serverBuilder = new WhoisServerBuilder(Source.IANA);
    private static final Logger LOGGER = LoggerFactory.getLogger(IANATopLevelDomainBuilder.class);

    IANATopLevelDomainBuilder(Properties properties) {
        super(Source.IANA);
        this.properties = properties;
    }

    @Override
    protected void completeTopLevelDomain(TopLevelDomain domain) throws WhoisServerListException, InterruptedException {
        try (Parser parser = new Parser();){
            String whoisHost = this.properties.getProperty("iana.whois.host");
            WhoisClient whoisClient = new WhoisClient();
            whoisClient.connect(whoisHost);
            InputStream inputStream = whoisClient.getInputStream(domain.getName());
            parser.setKeys(KEY_CREATED, KEY_CHANGED, KEY_WHOIS, KEY_STATE);
            String charset = this.properties.getProperty("iana.whois.charset");
            parser.parse(inputStream, Charset.forName(charset));
            domain.setState(parser.getState(KEY_STATE));
            domain.setCreated(parser.getDate(KEY_CREATED));
            domain.setChanged(parser.getDate(KEY_CHANGED));
            if (parser.getURLs().size() == 1) {
                domain.setRegistratonService(parser.getURLs().get(0));
            } else {
                LOGGER.info("found {} Url(s) for {}", (Object)parser.getURLs().size(), (Object)domain);
            }
            String host = parser.getString(KEY_WHOIS);
            if (host != null) {
                this.serverBuilder.setHost(host);
                WhoisServer server = (WhoisServer)this.serverBuilder.build();
                domain.getWhoisServers().add(server);
            } else {
                LOGGER.info("found no whois server for {}", (Object)domain);
            }
        }
        catch (IOException e) {
            throw new BuildDomainException(e);
        }
    }
}

