/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.helper.converter;

import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.converter.DocumentConverter;
import de.malkusch.whoisServerList.compiler.helper.converter.InputStreamToDocumentConverter;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;

@Immutable
public final class EntityToDocumentConverter
implements DocumentConverter<HttpEntity> {
    private final String defaultCharset;

    public EntityToDocumentConverter(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    @Override
    public Document convert(HttpEntity entity) throws WhoisServerListException {
        try {
            Header encoding = entity.getContentEncoding();
            String charset = this.defaultCharset;
            if (encoding != null) {
                charset = encoding.getValue();
            }
            InputStreamToDocumentConverter converter = new InputStreamToDocumentConverter(charset);
            return converter.convert(entity.getContent());
        }
        catch (IOException e) {
            throw new WhoisServerListException(e);
        }
    }
}

