/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.helper.converter;

import de.malkusch.whoisServerList.compiler.exception.WhoisServerListException;
import de.malkusch.whoisServerList.compiler.helper.converter.DocumentConverter;
import de.malkusch.whoisServerList.compiler.helper.converter.NodeToValueConverter;
import de.malkusch.whoisServerList.compiler.helper.converter.ThrowableConverter;
import de.malkusch.whoisServerList.compiler.helper.iterator.NodeListIterable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class DocumentToStringIteratorConvertor<T>
implements ThrowableConverter<T, Iterable<String>, WhoisServerListException> {
    private final XPathExpression xpath;
    private final DocumentConverter<T> documentConverter;

    public DocumentToStringIteratorConvertor(String xpath, DocumentConverter<T> documentConverter) throws WhoisServerListException {
        try {
            this.xpath = XPathFactory.newInstance().newXPath().compile(xpath);
            this.documentConverter = documentConverter;
        }
        catch (XPathExpressionException e) {
            throw new WhoisServerListException(e);
        }
    }

    @Override
    public Iterable<String> convert(T input) throws WhoisServerListException {
        try {
            NodeList tldNodes = (NodeList)this.xpath.evaluate(this.documentConverter.convert(input), XPathConstants.NODESET);
            return new NodeListIterable<Node, String>(tldNodes, new NodeToValueConverter());
        }
        catch (XPathExpressionException e) {
            throw new WhoisServerListException(e);
        }
    }
}

