/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.helper;

import de.malkusch.whoisServerList.compiler.DomainListCompiler;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ConcurrencyService {
    @PropertyKey
    public static final String PROPERTY_LEVEL = "concurrency.level";
    private final Executor executor;

    public ConcurrencyService() {
        this(DomainListCompiler.getDefaultProperties());
    }

    public ConcurrencyService(Properties properties) {
        this.executor = Executors.newFixedThreadPool(Integer.parseInt(properties.getProperty(PROPERTY_LEVEL)));
    }

    public static ConcurrencyService getService() {
        return ServiceLoader.load(ConcurrencyService.class).iterator().next();
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

