/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.compiler.filter.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.whois.WhoisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class WhoisServerPatternFilter
implements Filter<WhoisServer> {
    private final String unavailableQuery;
    private final int timeout;
    private static final int SECOND = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(WhoisServerPatternFilter.class);

    WhoisServerPatternFilter(@Nonnull String unavailableQuery, int timeout) {
        this.unavailableQuery = unavailableQuery;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public WhoisServer filter(@Nullable WhoisServer server) {
        if (server == null) {
            return null;
        }
        if (server.getAvailablePattern() == null) {
            return server;
        }
        WhoisClient whoisClient = new WhoisClient();
        whoisClient.setDefaultTimeout(this.timeout * 1000);
        try {
            whoisClient.connect(server.getHost());
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't query whois server '{}'", (Object)server.getHost());
            return server;
        }
        try (InputStream stream = whoisClient.getInputStream(this.unavailableQuery);){
            whoisClient.setSoTimeout(this.timeout * 1000);
            WhoisServer filtered = (WhoisServer)server.clone();
            String response = IOUtils.toString((InputStream)stream);
            Matcher matcher = server.getAvailablePattern().matcher(response);
            if (!matcher.find()) {
                LOGGER.warn("removing available pattern from '{}'", (Object)server.getHost());
                filtered.setAvailablePattern(null);
            }
            WhoisServer whoisServer = filtered;
            return whoisServer;
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't query whois server '{}'", (Object)server.getHost());
            return server;
        }
    }
}

