/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.compiler.filter.Filter;
import de.malkusch.whoisServerList.compiler.filter.TCPServiceFilter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class WhoisServerFilter
implements Filter<WhoisServer> {
    private final TCPServiceFilter tcpServiceFilter;
    private static final Logger LOGGER = LoggerFactory.getLogger(WhoisServerFilter.class);

    WhoisServerFilter(int timeout) {
        this.tcpServiceFilter = new TCPServiceFilter(43, timeout);
    }

    @Override
    @Nullable
    public WhoisServer filter(@Nullable WhoisServer server) {
        if (server == null) {
            return null;
        }
        String host = this.tcpServiceFilter.filter(server.getHost());
        if (host == null) {
            LOGGER.warn("removing whois server {}.", (Object)server.getHost());
            return null;
        }
        return server;
    }
}

