/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.compiler.filter.Filter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TCPServiceFilter
implements Filter<String> {
    private final int port;
    private final int timeout;
    private static final int SECOND = 1000;

    TCPServiceFilter(int port, int timeout) {
        this.port = port;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String filter(@Nullable String host) {
        if (host == null) {
            return null;
        }
        InetSocketAddress address = new InetSocketAddress(host, this.port);
        if (address.isUnresolved()) {
            return null;
        }
        try (Socket socket = new Socket();){
            socket.connect(address, this.timeout * 1000);
            String string = host;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

