/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.api.v1.model.domain.TopLevelDomain;
import de.malkusch.whoisServerList.compiler.filter.AbstractListFilter;
import de.malkusch.whoisServerList.compiler.filter.ConcurrentListFilter;
import de.malkusch.whoisServerList.compiler.filter.Filter;
import de.malkusch.whoisServerList.compiler.filter.TopLevelDomainFilter;
import de.malkusch.whoisServerList.compiler.helper.comparator.DomainComparator;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DomainListFilter
implements Filter<DomainList> {
    private final AbstractListFilter<TopLevelDomain> domainFilter;
    private final DomainComparator comparator;
    @PropertyKey
    private static final String PROPERTY_TIMEOUT = "filter.whois.timeout";

    public DomainListFilter(int timeout) {
        this.domainFilter = new ConcurrentListFilter<TopLevelDomain>(new TopLevelDomainFilter(timeout));
        this.comparator = new DomainComparator();
    }

    public DomainListFilter(Properties properties) {
        this(Integer.parseInt(properties.getProperty(PROPERTY_TIMEOUT)));
    }

    @Override
    public DomainList filter(DomainList domainList) throws InterruptedException {
        if (domainList == null) {
            return null;
        }
        DomainList filtered = domainList.clone();
        List domains = this.domainFilter.filter((TopLevelDomain)domainList.getDomains());
        Collections.sort(domains, this.comparator);
        filtered.setDomains(domains);
        return filtered;
    }
}

