/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.api.v1.model.domain.Domain;
import de.malkusch.whoisServerList.compiler.filter.Filter;
import de.malkusch.whoisServerList.compiler.filter.FilterChain;
import de.malkusch.whoisServerList.compiler.filter.ListFilter;
import de.malkusch.whoisServerList.compiler.filter.StringFilter;
import de.malkusch.whoisServerList.compiler.filter.WhoisServerFilter;
import de.malkusch.whoisServerList.compiler.filter.WhoisServerPatternFilter;
import de.malkusch.whoisServerList.compiler.helper.comparator.WhoisServerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
class DomainFilter<T extends Domain>
implements Filter<T> {
    private final int timeout;
    private final StringFilter nameFilter;
    private final WhoisServerFilter whoisServerFilter;
    private final WhoisServerComparator comparator;
    private static final String UNAVAILABLE_QUERY = "hST4vcMRppEPgENMHD2";

    DomainFilter(int timeout) {
        this.whoisServerFilter = new WhoisServerFilter(timeout);
        this.timeout = timeout;
        this.nameFilter = new StringFilter();
        this.comparator = new WhoisServerComparator();
    }

    @Override
    public final T filter(T domain) throws InterruptedException {
        if (domain == null) {
            return null;
        }
        Domain filtered = (Domain)domain.clone();
        filtered.setName(this.nameFilter.filter(domain.getName()));
        ArrayList chain = new ArrayList();
        chain.add(this.whoisServerFilter);
        String query = String.format("%s.%s", UNAVAILABLE_QUERY, domain.getName());
        chain.add(new WhoisServerPatternFilter(query, this.timeout));
        ListFilter listFilter = new ListFilter(new FilterChain(chain));
        List filteredServers = listFilter.filter(domain.getWhoisServers());
        Collections.sort(filteredServers, this.comparator);
        filtered.setWhoisServers(filteredServers);
        filtered = this.filterDomain(filtered);
        return (T)filtered;
    }

    T filterDomain(T domain) {
        return domain;
    }
}

