/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.filter;

import de.malkusch.whoisServerList.compiler.filter.AbstractListFilter;
import de.malkusch.whoisServerList.compiler.filter.Filter;
import de.malkusch.whoisServerList.compiler.helper.ConcurrencyService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConcurrentListFilter<T>
extends AbstractListFilter<T> {
    private final Executor executor = ConcurrencyService.getService().getExecutor();

    ConcurrentListFilter(Filter<T> filter) {
        super(filter);
    }

    @Override
    public List<T> filter(List<T> list) throws InterruptedException {
        try {
            if (list == null) {
                return null;
            }
            ArrayList filteredList = new ArrayList();
            ArrayList tasks = new ArrayList();
            for (final T t : list) {
                FutureTask task = new FutureTask(new Callable<T>(){

                    @Override
                    public T call() throws InterruptedException {
                        return ConcurrentListFilter.this.filterItem(t);
                    }
                });
                tasks.add(task);
                this.executor.execute(task);
            }
            for (FutureTask futureTask : tasks) {
                Object filtered = futureTask.get();
                if (filtered == null) continue;
                filteredList.add(filtered);
            }
            return filteredList;
        }
        catch (ExecutionException e) {
            if (e.getCause() == null) {
                throw new RuntimeException(e);
            }
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }
}

