/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.compiler.filter.DomainListFilter;
import de.malkusch.whoisServerList.compiler.helper.VersionUtil;
import de.malkusch.whoisServerList.compiler.list.DomainListFactory;
import de.malkusch.whoisServerList.compiler.list.exception.BuildListException;
import de.malkusch.whoisServerList.compiler.list.iana.IanaDomainListFactory;
import de.malkusch.whoisServerList.compiler.list.psl.PublicSuffixDomainListFactory;
import de.malkusch.whoisServerList.compiler.list.xml.XMLDomainListFactory;
import de.malkusch.whoisServerList.compiler.merger.DomainListMerger;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DomainListCompiler {
    private final DomainListFactory[] listFactories;
    private final DomainListMerger merger;
    private final DomainListFilter filter;

    public static Properties getDefaultProperties() {
        try {
            Properties properties = new Properties();
            properties.load(DomainListCompiler.class.getResourceAsStream("/compiler.properties"));
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DomainListCompiler() {
        this(DomainListCompiler.getDefaultProperties());
    }

    public DomainListCompiler(Properties properties) {
        this.listFactories = new DomainListFactory[]{new XMLDomainListFactory(), new IanaDomainListFactory(properties), new PublicSuffixDomainListFactory()};
        this.merger = new DomainListMerger(properties);
        this.filter = new DomainListFilter(properties);
    }

    public DomainList compile() throws BuildListException, InterruptedException {
        DomainList compiledList = new DomainList();
        for (DomainListFactory listFactory : this.listFactories) {
            compiledList = this.merger.merge(compiledList, listFactory.buildList());
        }
        compiledList.setDate(new Date());
        compiledList.setVersion(VersionUtil.incrementVersion(compiledList.getVersion()));
        compiledList = this.filter.filter(compiledList);
        return compiledList;
    }
}

