/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.parser;

import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.rule.RuleFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Parser {
    private static Pattern ruleLine = Pattern.compile("^(\\S+)");
    private static Pattern commentLine = Pattern.compile("^//.*$");
    private static Pattern whiteSpaceLine = Pattern.compile("^\\s*$");
    private final RuleFactory ruleFactory = new RuleFactory();

    public List<Rule> parse(InputStream stream, Charset charset) throws IOException {
        String line;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        while ((line = reader.readLine()) != null) {
            Rule rule = this.parseLine(line);
            if (rule == null) continue;
            rules.add(this.parseLine(line));
        }
        return rules;
    }

    public Rule parseLine(String line) {
        if (line == null) {
            return null;
        }
        String trimmedline = line.trim();
        if (commentLine.matcher(trimmedline).matches()) {
            return null;
        }
        if (whiteSpaceLine.matcher(trimmedline).matches()) {
            return null;
        }
        Matcher matcher = ruleLine.matcher(trimmedline);
        if (!matcher.find()) {
            return null;
        }
        return this.ruleFactory.build(matcher.group(1));
    }
}

