/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.index.tree;

import de.malkusch.whoisServerList.publicSuffixList.index.tree.Node;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableNode
extends Node<ImmutableNode> {
    private final Rule rule;

    ImmutableNode(String label, Map<String, ImmutableNode> children, Rule rule) {
        super(label, Collections.unmodifiableMap(children));
        this.rule = rule;
    }

    @Override
    Rule getRule() {
        return this.rule;
    }

    Collection<ImmutableNode> findNodes(String domain) {
        return this.findNodes(this.convertDomain(domain));
    }

    Collection<ImmutableNode> findNodes(Deque<String> labels) {
        ImmutableNode wildcard;
        LinkedList<ImmutableNode> nodes = new LinkedList<ImmutableNode>();
        if (labels.isEmpty()) {
            return nodes;
        }
        String searchLabel = labels.removeLast();
        ImmutableNode child = (ImmutableNode)this.getChild(searchLabel);
        if (child != null) {
            nodes.add(child);
        }
        if ((wildcard = (ImmutableNode)this.getWildcard()) != null) {
            nodes.add(wildcard);
        }
        for (ImmutableNode node : new ArrayList<ImmutableNode>(nodes)) {
            nodes.addAll(node.findNodes(new LinkedList<String>(labels)));
        }
        return nodes;
    }

    Collection<ImmutableNode> getDescendants() {
        ArrayList<ImmutableNode> descendants = new ArrayList<ImmutableNode>(this.getChildren());
        for (ImmutableNode child : this.getChildren()) {
            descendants.addAll(child.getDescendants());
        }
        return descendants;
    }
}

