/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.api.v1;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

@Immutable
public final class DomainListFactory {
    @PropertyKey
    public static final String PROPERTY_URL = "whoisserverlist.url";
    @PropertyKey
    public static final String PROPERTY_FILE = "whoisserverlist.file";
    public static final String PROPERTYFILE = "/api.properties";

    private static Properties getDefaults() {
        try {
            Properties defaults = new Properties();
            defaults.load(DomainListFactory.class.getResourceAsStream(PROPERTYFILE));
            return defaults;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DomainList build(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DomainList.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (DomainList)DomainList.class.cast(unmarshaller.unmarshal(url));
    }

    public DomainList build() {
        try {
            Properties defaults = DomainListFactory.getDefaults();
            URL localList = this.getClass().getResource(defaults.getProperty(PROPERTY_FILE));
            return this.build(localList);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public DomainList download() throws JAXBException {
        try {
            Properties defaults = DomainListFactory.getDefaults();
            URL url = new URL(defaults.getProperty(PROPERTY_URL));
            return this.build(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

