/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.api.v0;

import de.malkusch.whoisServerList.api.v0.model.Serverlist;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.jcip.annotations.Immutable;

@Immutable
public final class ServerListFactory {
    public static final String PROPERTY_URL = "whoisserverlist.url";
    public static final String PROPERTY_FILE = "whoisserverlist.file";
    public static final String PROPERTYFILE = "/api.properties";

    private static Properties getDefaults() {
        try {
            Properties defaults = new Properties();
            defaults.load(ServerListFactory.class.getResourceAsStream(PROPERTYFILE));
            return defaults;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Serverlist build(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Serverlist.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (Serverlist)Serverlist.class.cast(unmarshaller.unmarshal(url));
    }

    public Serverlist build() {
        try {
            Properties defaults = ServerListFactory.getDefaults();
            URL localList = this.getClass().getResource(defaults.getProperty(PROPERTY_FILE));
            return this.build(localList);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Serverlist download() throws JAXBException {
        try {
            Properties defaults = ServerListFactory.getDefaults();
            URL url = new URL(defaults.getProperty(PROPERTY_URL));
            return this.build(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

