/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.soapClientCache.cache.dataSource.call;

import de.malkusch.soapClientCache.cache.dataSource.call.DataSourceCall;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class DataSourceQuery<T>
extends DataSourceCall {
    private T result;

    public DataSourceQuery(DataSource dataSource, String query) {
        super(dataSource, query);
    }

    protected void setResult(T result) {
        this.result = result;
    }

    protected T getObject(ResultSet resultSet, int index) throws SQLException, IOException, ClassNotFoundException {
        Object object;
        byte[] bytes = resultSet.getBytes(1);
        if (bytes == null) {
            return null;
        }
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object castedObject = object = objectStream.readObject();
        return (T)castedObject;
    }

    protected abstract void readResults(ResultSet var1) throws SQLException, IOException, ClassNotFoundException;

    public T query() throws SQLException, IOException, ClassNotFoundException {
        this.execute();
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(PreparedStatement statement) throws SQLException, IOException, ClassNotFoundException {
        try (ResultSet results = statement.executeQuery();){
            while (results.next()) {
                this.readResults(results);
            }
        }
    }
}

