/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.soapClientCache.cache.dataSource.call;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class DataSourceCall {
    private DataSource dataSource;
    private String query;

    public DataSourceCall(DataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
    }

    abstract void execute(PreparedStatement var1) throws SQLException, IOException, ClassNotFoundException;

    protected void setParameters(PreparedStatement statement) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException, IOException, ClassNotFoundException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.query);){
            this.setParameters(statement);
            this.execute(statement);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
    }
}

