/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.soapClientCache.cache.dataSource;

import de.malkusch.soapClientCache.cache.Cache;
import de.malkusch.soapClientCache.cache.Payload;
import de.malkusch.soapClientCache.cache.dataSource.call.DataSourceExecution;
import de.malkusch.soapClientCache.cache.dataSource.call.DataSourceQuery;
import de.malkusch.soapClientCache.cache.exception.CacheException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceCache<K extends Serializable, V>
extends Cache<K, V> {
    private DataSource dataSource;

    private int adaptKey(K key) {
        return key.hashCode();
    }

    public DataSourceCache(int expireSeconds, DataSource dataSource) throws IOException, ClassNotFoundException {
        super(expireSeconds);
        this.dataSource = dataSource;
        try {
            new DataSourceExecution(dataSource, "CREATE TABLE soapcache(\tcachekey INT NOT NULL PRIMARY KEY,\tpayload BLOB)").execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected Payload<V> getPayload(K key) throws CacheException {
        try {
            return (Payload)new DataSourceQuery<Payload<V>>(this.dataSource, "SELECT payload from soapcache WHERE cachekey=?", (Serializable)key){
                final /* synthetic */ Serializable val$key;
                {
                    this.val$key = serializable;
                    super(x0, x1);
                }

                @Override
                protected void setParameters(PreparedStatement statement) throws SQLException {
                    statement.setInt(1, DataSourceCache.this.adaptKey(this.val$key));
                }

                @Override
                protected void readResults(ResultSet results) throws SQLException, IOException, ClassNotFoundException {
                    this.setResult(this.getObject(results, 1));
                }
            }.query();
        }
        catch (SQLException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void put(K key, final Payload<V> payload) throws CacheException {
        try {
            try {
                new DataSourceExecution(this.dataSource, "INSERT INTO soapcache (cachekey, payload) VALUES(?, ?)", (Serializable)key, payload){
                    final /* synthetic */ Serializable val$key;
                    final /* synthetic */ Payload val$payload;
                    {
                        this.val$key = serializable;
                        this.val$payload = payload;
                        super(x0, x1);
                    }

                    @Override
                    protected void setParameters(PreparedStatement statement) throws SQLException {
                        statement.setInt(1, DataSourceCache.this.adaptKey(this.val$key));
                        statement.setObject(2, this.val$payload);
                    }
                }.execute();
            }
            catch (SQLException e) {
                new DataSourceExecution(this.dataSource, "UPDATE soapcache SET payload=? WHERE cachekey=?", (Serializable)key){
                    final /* synthetic */ Serializable val$key;
                    {
                        this.val$key = serializable;
                        super(x0, x1);
                    }

                    @Override
                    protected void setParameters(PreparedStatement statement) throws SQLException {
                        statement.setObject(1, payload);
                        statement.setInt(2, DataSourceCache.this.adaptKey(this.val$key));
                    }
                }.execute();
            }
        }
        catch (SQLException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }

    @Override
    protected void remove(K key) throws CacheException {
        try {
            new DataSourceExecution(this.dataSource, "DELETE FROM soapcache WHERE cachekey=?", (Serializable)key){
                final /* synthetic */ Serializable val$key;
                {
                    this.val$key = serializable;
                    super(x0, x1);
                }

                @Override
                protected void setParameters(PreparedStatement statement) throws SQLException {
                    statement.setInt(1, DataSourceCache.this.adaptKey(this.val$key));
                }
            }.execute();
        }
        catch (SQLException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void clear() throws CacheException {
        try {
            new DataSourceExecution(this.dataSource, "DELETE FROM soapcache").execute();
        }
        catch (SQLException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }
}

