/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.soapClientCache.cache;

import de.malkusch.soapClientCache.cache.Payload;
import de.malkusch.soapClientCache.cache.PayloadFactory;
import de.malkusch.soapClientCache.cache.exception.CacheException;
import java.util.Calendar;

public abstract class Cache<K, V> {
    private int expireSeconds;
    private PayloadFactory<V> payloadFactory = new PayloadFactory();

    protected abstract Payload<V> getPayload(K var1) throws CacheException;

    public abstract void put(K var1, Payload<V> var2) throws CacheException;

    protected abstract void remove(K var1) throws CacheException;

    public abstract void clear() throws CacheException;

    public Cache(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public void setPayloadFactory(PayloadFactory<V> factory) {
        this.payloadFactory = factory;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    public void put(K key, V object) throws CacheException {
        Payload<V> payload = this.payloadFactory.getInstance(object);
        this.update(payload);
        this.put(key, (V)payload);
    }

    public V get(K key) throws CacheException {
        Payload<V> payload = this.getPayload(key);
        if (payload == null) {
            return null;
        }
        if (payload.getExpiration().before(Calendar.getInstance())) {
            this.remove(key);
            return null;
        }
        return payload.getPayload();
    }

    private void update(Payload<V> payload) {
        payload.getExpiration().add(13, this.expireSeconds);
    }
}

