/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.soapClientCache;

import de.malkusch.soapClientCache.cache.Cache;
import de.malkusch.soapClientCache.cache.exception.CacheException;
import de.malkusch.soapClientCache.key.KeyAdapter;
import de.malkusch.soapClientCache.key.SOAPMessageAdapter;
import de.malkusch.soapClientCache.message.SOAPMessagePayloadFactory;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String CACHE_KEY = CacheHandler.class.getName() + ".cacheKey";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Cache<String, SOAPMessage> cache;
    private KeyAdapter keyAdapter;

    public CacheHandler(Cache<String, SOAPMessage> cache, KeyAdapter keyAdapter) {
        this.cache = cache;
        this.keyAdapter = keyAdapter;
        cache.setPayloadFactory(new SOAPMessagePayloadFactory());
    }

    public CacheHandler(Cache<String, SOAPMessage> cache) {
        this(cache, new SOAPMessageAdapter());
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        return outbound != false ? this.handleRequestMessage(context) : this.handleResponseMessage(context);
    }

    private boolean handleRequestMessage(SOAPMessageContext context) {
        try {
            String cacheKey = this.keyAdapter.adapt(context);
            SOAPMessage cachedMessage = this.cache.get(cacheKey);
            if (cachedMessage == null) {
                context.put((Object)CACHE_KEY, (Object)cacheKey);
                return true;
            }
            context.setMessage(cachedMessage);
            return false;
        }
        catch (CacheException e) {
            this.logger.warn("skip cache lookup", (Throwable)e);
            return true;
        }
    }

    private boolean handleResponseMessage(SOAPMessageContext context) {
        try {
            String cacheKey = (String)context.get((Object)CACHE_KEY);
            if (cacheKey != null) {
                this.cache.put(cacheKey, context.getMessage());
            }
            return true;
        }
        catch (CacheException e) {
            this.logger.warn("skip cache storing", (Throwable)e);
            return true;
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

