/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.broadlinkBulb.mob41.lb1;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import de.malkusch.broadlinkBulb.mob41.lb1.Codec;
import de.malkusch.broadlinkBulb.mob41.lb1.Lb2StateCmdPayload;
import de.malkusch.broadlinkBulb.mob41.lb1.State;
import java.io.IOException;
import java.net.DatagramPacket;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public final class LB1Device
extends BLDevice {
    private final String mac;
    private final String host;
    private final Duration timeout;
    private final Codec codec;
    public static final short DEVICE_TYPE = -56;
    private static final int FLAG_WRITE = 2;
    private static final int FLAG_READ = 1;

    public LB1Device(String host, String mac, Duration timeout, Codec codec) throws IOException {
        super((short)-56, "Smart bulb LB1", host, LB1Device.reverseMac(mac));
        this.mac = mac;
        this.host = host;
        this.timeout = timeout;
        this.codec = codec;
    }

    public void changeState(State state) throws IOException {
        Map<String, Object> changed = this.send(state, 2).toMap();
        for (Map.Entry<String, Object> entry : state.toMap().entrySet()) {
            Object actual;
            String key = entry.getKey();
            Object expected = entry.getValue();
            if (expected == null || expected.equals(actual = changed.get(key))) continue;
            throw new IOException(String.format("%s failed changing %s to %s, was %s", new Object[]{this, key, expected, actual}));
        }
    }

    public State readState() throws IOException {
        return this.send(State.EMPTY, 1);
    }

    private State send(State state, int flag) throws IOException {
        byte[] decrypted;
        Lb2StateCmdPayload cmd = this.codec.encode(state, flag);
        DatagramPacket response = this.sendCmdPkt((int)this.timeout.toMillis(), cmd);
        byte[] encrypted = response.getData();
        if (34 >= encrypted.length) {
            throw new IOException("Received to few data " + encrypted.length + " bytes");
        }
        int err = encrypted[34] | encrypted[35] << 8;
        if (err != 0) {
            throw new IOException(String.format("%s received returned err: %s/%d", new Object[]{this, Integer.toHexString(err), err}));
        }
        try {
            decrypted = this.decryptFromDeviceMessage(encrypted);
        }
        catch (Exception e) {
            throw new IOException(String.format("%s can't decrypt response", new Object[]{this}), e);
        }
        return this.codec.decode(decrypted);
    }

    public String mac() {
        return this.mac;
    }

    public String host() {
        return this.host;
    }

    public int hashCode() {
        return Objects.hash(this.mac, this.host);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LB1Device)) {
            return false;
        }
        LB1Device otherDevice = (LB1Device)((Object)other);
        return this.host.equals(otherDevice.host) && this.mac.equals(otherDevice.mac);
    }

    public String toString() {
        return String.format("%s [%s]", this.host, this.mac);
    }

    private static Mac reverseMac(String mac) {
        byte[] bytes = Mac.macStrToBytes((String)mac);
        byte[] reversed = new byte[]{bytes[5], bytes[4], bytes[3], bytes[2], bytes[1], bytes[0]};
        return new Mac(reversed);
    }
}

