/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.broadlinkBulb;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.dis.DiscoveryPacket;
import de.malkusch.broadlinkBulb.BroadlinkBulb;
import de.malkusch.broadlinkBulb.mob41.lb1.Codec;
import de.malkusch.broadlinkBulb.mob41.lb1.LB1Device;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BroadlinkBulbFactory {
    private static final System.Logger log = System.getLogger(BroadlinkBulbFactory.class.getName());
    private final Duration timeout;
    private final Codec codec = new Codec();
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);

    public BroadlinkBulbFactory(Duration timeout) {
        this.timeout = Objects.requireNonNull(timeout);
    }

    public BroadlinkBulbFactory() {
        this(DEFAULT_TIMEOUT);
    }

    public Collection<BroadlinkBulb> discover() throws IOException {
        List<InetAddress> addresses = NetworkInterface.networkInterfaces().flatMap(it -> it.getInterfaceAddresses().stream()).map(it -> it.getAddress()).filter(it -> it instanceof Inet4Address).filter(it -> !it.isLoopbackAddress()).filter(it -> !it.isLinkLocalAddress()).toList();
        ArrayList<BroadlinkBulb> lights = new ArrayList<BroadlinkBulb>();
        for (InetAddress address : addresses) {
            lights.addAll(this.discover(address));
        }
        return lights;
    }

    public Collection<BroadlinkBulb> discover(String source) throws IOException {
        return this.discover(InetAddress.getByName(source));
    }

    public Collection<BroadlinkBulb> discover(InetAddress source) throws IOException {
        ArrayList<BroadlinkBulb> lights = new ArrayList<BroadlinkBulb>();
        try (Connection connection = new Connection(source, InetAddress.getByName("255.255.255.255"), this.timeout, true);){
            Optional<Connection.Response> next = connection.readNext();
            while (next.isPresent()) {
                Connection.Response response = next.get();
                BroadlinkBulb light = this.build(response);
                log.log(System.Logger.Level.INFO, "Discovered {0}", light);
                lights.add(light);
                next = connection.readNext();
            }
        }
        return lights;
    }

    public BroadlinkBulb build(String target) throws IOException {
        return this.build(InetAddress.getByName(target));
    }

    public BroadlinkBulb build(InetAddress target) throws IOException {
        try (Connection connection = Connection.connection(target, this.timeout, false);){
            Connection.Response response = connection.readNext().orElseThrow(() -> new IOException(String.format("Could not discover device %s", target)));
            BroadlinkBulb broadlinkBulb = this.build(response);
            return broadlinkBulb;
        }
    }

    private BroadlinkBulb build(Connection.Response response) throws IOException {
        LB1Device device = new LB1Device(response.host, response.mac, this.timeout, this.codec);
        return new BroadlinkBulb(device);
    }

    private static final class Connection
    implements AutoCloseable {
        private static final System.Logger log = System.getLogger(Connection.class.getName());
        private final InetAddress sourceIpAddr;
        private final int sourcePort = 0;
        private final DatagramSocket socket;
        private final byte[] readBuffer = new byte[64];

        public static Connection connection(InetAddress target, Duration timeout, boolean broadcast) throws IOException {
            DatagramSocket sock = new DatagramSocket();
            sock.connect(target, 80);
            InetAddress source = sock.getLocalAddress();
            return new Connection(sock, source, target, timeout, broadcast);
        }

        public Connection(InetAddress source, InetAddress target, Duration timeout, boolean broadcast) throws IOException {
            this(new DatagramSocket(0, source), source, target, timeout, broadcast);
        }

        private Connection(DatagramSocket sock, InetAddress source, InetAddress target, Duration timeout, boolean broadcast) throws IOException {
            this.sourceIpAddr = source;
            this.socket = sock;
            sock.setSoTimeout((int)timeout.toMillis());
            if (broadcast) {
                sock.setBroadcast(true);
                sock.setReuseAddress(true);
            }
            log.log(System.Logger.Level.DEBUG, "Discover from {0} at {1}", this.sourceIpAddr, target);
            DiscoveryPacket dpkt = new DiscoveryPacket(this.sourceIpAddr, 0);
            byte[] sendBytes = dpkt.getData();
            DatagramPacket sendpack = new DatagramPacket(sendBytes, sendBytes.length, target, 80);
            sock.send(sendpack);
        }

        private Optional<DatagramPacket> readNextPacket() throws IOException {
            DatagramPacket packet = new DatagramPacket(this.readBuffer, 0, this.readBuffer.length);
            try {
                this.socket.receive(packet);
                return Optional.of(packet);
            }
            catch (SocketTimeoutException e) {
                log.log(System.Logger.Level.DEBUG, "Stop discovery at {0}", this.sourceIpAddr);
                return Optional.empty();
            }
        }

        public Optional<Response> readNext() throws IOException {
            Optional<DatagramPacket> next = this.readNextPacket();
            if (next.isEmpty()) {
                return Optional.empty();
            }
            DatagramPacket recePacket = next.get();
            String host = recePacket.getAddress().getHostAddress();
            Mac mac = new Mac(BLDevice.reverseBytes((byte[])BLDevice.subbytes((byte[])this.readBuffer, (int)58, (int)64)));
            short deviceType = (short)(this.readBuffer[52] | this.readBuffer[53] << 8);
            log.log(System.Logger.Level.DEBUG, "Info: host=" + host + " mac=" + mac.getMacString() + " deviceType=0x" + Integer.toHexString(deviceType));
            log.log(System.Logger.Level.DEBUG, "Creating BLDevice instance");
            if (deviceType != -56) {
                log.log(System.Logger.Level.DEBUG, "{0} is unsupported device type {1}", host, deviceType);
                return Optional.empty();
            }
            return Optional.of(new Response(host, mac.toString()));
        }

        @Override
        public void close() {
            this.socket.close();
        }

        private record Response(String host, String mac) {
        }
    }
}

