/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.broadlinkBulb;

import de.malkusch.broadlinkBulb.Brightness;
import de.malkusch.broadlinkBulb.Color;
import de.malkusch.broadlinkBulb.mob41.lb1.LB1Device;
import de.malkusch.broadlinkBulb.mob41.lb1.State;
import java.io.IOException;

public final class BroadlinkBulb
implements AutoCloseable {
    private final LB1Device device;

    BroadlinkBulb(LB1Device device) throws IOException {
        this.device = device;
        if (!device.auth()) {
            throw new IllegalArgumentException("Failed to authenticate");
        }
    }

    public String mac() {
        return this.device.mac();
    }

    public String host() {
        return this.device.host();
    }

    public String toString() {
        return String.format("%s (%s)", this.host(), this.mac());
    }

    public void turnOff() throws IOException {
        State state = new State();
        state.pwr = State.Power.OFF;
        this.device.changeState(state);
    }

    public void turnOn() throws IOException {
        State state = new State();
        state.pwr = State.Power.ON;
        this.device.changeState(state);
    }

    public boolean isOn() throws IOException {
        State state = this.device.readState();
        return state.pwr == State.Power.ON;
    }

    public void dimm(Brightness brightness) throws IOException {
        State state = new State();
        state.brightness = brightness.value();
        this.device.changeState(state);
    }

    public Brightness brightness() throws IOException {
        State state = this.device.readState();
        return new Brightness(state.brightness);
    }

    public void shineWhite() throws IOException {
        State state = new State();
        state.bulb_colormode = State.ColorMode.WHITE;
        this.device.changeState(state);
    }

    public boolean isWhite() throws IOException {
        State state = this.device.readState();
        return state.bulb_colormode == State.ColorMode.WHITE;
    }

    public void changeColor(Color color) throws IOException {
        State state = new State();
        state.red = color.red().value();
        state.green = color.green().value();
        state.blue = color.blue().value();
        state.bulb_colormode = State.ColorMode.RGB;
        this.device.changeState(state);
    }

    public boolean isColor() throws IOException {
        State state = this.device.readState();
        return state.bulb_colormode == State.ColorMode.RGB;
    }

    public Color color() throws IOException {
        State state = this.device.readState();
        Color color = new Color(state.red, state.green, state.blue);
        return color;
    }

    public int hashCode() {
        return this.device.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BroadlinkBulb)) {
            return false;
        }
        BroadlinkBulb otherLight = (BroadlinkBulb)other;
        return this.device.equals((Object)otherLight.device);
    }

    @Override
    public void close() {
        this.device.close();
    }
}

