/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.broadlinkBulb.mob41.lb1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.pkt.BytePayload;
import com.github.mob41.blapi.pkt.Payload;
import de.malkusch.broadlinkBulb.mob41.Checksum;
import de.malkusch.broadlinkBulb.mob41.lb1.Lb2StateCmdPayload;
import de.malkusch.broadlinkBulb.mob41.lb1.Packer;
import de.malkusch.broadlinkBulb.mob41.lb1.State;
import de.malkusch.broadlinkBulb.mob41.lb1.Unpacker;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Codec {
    private static final Logger log = LoggerFactory.getLogger(Codec.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Unpacker unpacker = new Unpacker();
    private final Packer packer = new Packer();

    public State decode(byte[] response) throws IOException {
        int js_len = (int)this.unpacker.unpack_js_len(response);
        byte[] json_data = BLDevice.subbytes((byte[])response, (int)14, (int)(14 + js_len));
        log.debug("decoded: {}", (Object)new String(json_data));
        return (State)this.mapper.readValue(json_data, State.class);
    }

    public Lb2StateCmdPayload encode(State state, int flag) throws IOException {
        try {
            byte[] data = this.json(state);
            int p_len = 12 + data.length;
            byte[] packet = this.packer.pack(p_len, flag, data.length);
            packet = Codec.extend(packet, data);
            byte[] checksum = Checksum.checksum(packet, 2);
            packet[6] = checksum[0];
            packet[7] = checksum[1];
            return new Lb2StateCmdPayload((Payload)new BytePayload(packet));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    byte[] json(State state) throws IOException {
        byte[] json = this.mapper.writeValueAsBytes((Object)state);
        log.debug("Serialized state to: {}", (Object)new String(json));
        return json;
    }

    private static byte[] extend(byte[] first, byte[] second) {
        byte[] extended = new byte[first.length + second.length];
        System.arraycopy(first, 0, extended, 0, first.length);
        System.arraycopy(second, 0, extended, first.length, second.length);
        return extended;
    }
}

