/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.broadlinkBulb;

import java.util.Objects;

public record Color(Red red, Green green, Blue blue) {
    public Color(int red, int green, int blue) {
        this(new Red(red), new Green(green), new Blue(blue));
    }

    public Color {
        Objects.requireNonNull(red);
        Objects.requireNonNull(green);
        Objects.requireNonNull(blue);
    }

    private static void assertValidColorValue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Color must be between 0 and 255");
        }
    }

    public record Red(int value) {
        public Red {
            Color.assertValidColorValue(value);
        }
    }

    public record Green(int value) {
        public Green {
            Color.assertValidColorValue(value);
        }
    }

    public record Blue(int value) {
        public Blue {
            Color.assertValidColorValue(value);
        }
    }
}

