/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.trustmanager;

import cats.NotNull$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lhns.trustmanager.TrustManagers;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.Either;

public final class TrustManagers$ {
    public static TrustManagers$ MODULE$;
    private X509TrustManager jreTrustManager;
    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager;
    private Option<X509TrustManager> trustManagerFromEnvVar;
    private X509TrustManager jreTrustManagerWithEnvVar;
    private Option<X509TrustManager> insecureTrustManagerFromEnvVar;
    private final X509TrustManager insecureTrustManager;
    private final Semigroup<X509TrustManager> trustManagerSemigroup;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new TrustManagers$();
    }

    public X509TrustManager insecureTrustManager() {
        return this.insecureTrustManager;
    }

    public Semigroup<X509TrustManager> trustManagerSemigroup() {
        return this.trustManagerSemigroup;
    }

    public X509TrustManager trustManagerFromKeyStore(KeyStore keyStore) {
        X509TrustManager x509TrustManager;
        Object object = new Object();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManagerFactory.getTrustManagers())).foreach((Function1 & Serializable & scala.Serializable)trustManager -> {
                TrustManager trustManager2 = trustManager;
                if (trustManager2 instanceof X509TrustManager) {
                    X509TrustManager x509TrustManager = (X509TrustManager)trustManager2;
                    throw new NonLocalReturnControl(object, (Object)x509TrustManager);
                }
                throw new MatchError((Object)trustManager2);
            });
            x509TrustManager = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                x509TrustManager = (X509TrustManager)ex.value();
            }
            throw ex;
        }
        return x509TrustManager;
    }

    private X509TrustManager jreTrustManager$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                LazyRef trustStoreType$lzy = new LazyRef();
                LazyRef trustStoreProvider$lzy = new LazyRef();
                LazyRef trustStore$lzy = new LazyRef();
                LazyRef trustStorePassword$lzy = new LazyRef();
                Option keyStore = TrustManagers$.trustStore$1(trustStore$lzy).map((Function1 & Serializable & scala.Serializable)trustStorePath -> {
                    KeyStore keyStore = (KeyStore)TrustManagers$.trustStoreProvider$1(trustStoreProvider$lzy).fold((Function0 & Serializable & scala.Serializable)() -> KeyStore.getInstance(TrustManagers$.trustStoreType$1(trustStoreType$lzy)), (Function1 & Serializable & scala.Serializable)trustStoreProvider -> KeyStore.getInstance(TrustManagers$.trustStoreType$1(trustStoreType$lzy), trustStoreProvider));
                    try (FileInputStream inputStream = new FileInputStream((String)trustStorePath);){
                        keyStore.load(inputStream, (char[])TrustManagers$.trustStorePassword$1(trustStorePassword$lzy).orNull(Predef$.MODULE$.$conforms()));
                    }
                    return keyStore;
                });
                this.jreTrustManager = this.trustManagerFromKeyStore((KeyStore)keyStore.orNull(Predef$.MODULE$.$conforms()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.jreTrustManager;
    }

    public X509TrustManager jreTrustManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.jreTrustManager$lzycompute();
        }
        return this.jreTrustManager;
    }

    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.defaultThreadSafeTrustManager = new TrustManagers.ThreadSafeX509TrustManager(this.jreTrustManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.defaultThreadSafeTrustManager;
    }

    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.defaultThreadSafeTrustManager$lzycompute();
        }
        return this.defaultThreadSafeTrustManager;
    }

    public X509TrustManager defaultTrustManager() {
        return this.defaultThreadSafeTrustManager().get();
    }

    public void setDefaultTrustManager(X509TrustManager trustManager) {
        this.defaultThreadSafeTrustManager().set(trustManager);
        SSLContext.setDefault(this.sslContext(this.defaultThreadSafeTrustManager()));
    }

    private SSLContext sslContext(X509TrustManager trustManager) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{trustManager}), null);
        return sslContext;
    }

    public KeyStore keyStoreFromCertificates(Seq<Certificate> certificates) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char()));
        ((IterableLike)certificates.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TrustManagers$.$anonfun$keyStoreFromCertificates$1(keyStore, x0$1);
            return BoxedUnit.UNIT;
        });
        return keyStore;
    }

    public Either<CertificateException, X509Certificate> x509CertificateFromBytes(byte[] bytes) {
        return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable & scala.Serializable)() -> (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(bytes)), ClassTag$.MODULE$.apply(CertificateException.class), NotNull$.MODULE$.catsNotNullForA());
    }

    private Logger logger() {
        return this.logger;
    }

    public X509TrustManager trustManagerFromCertificatePath(Path path2) {
        return this.trustManagerFromKeyStore(this.keyStoreFromCertificates((Seq<Certificate>)TraversableOnce$.MODULE$.MonadOps(TraversableOnce$.MODULE$.MonadOps(Files.isDirectory(path2, new LinkOption[0]) ? (TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(path2).iterator()).asScala() : (TraversableOnce)new .colon.colon((Object)path2, (List)Nil$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)TrustManagers$.$anonfun$trustManagerFromCertificatePath$1(path)))).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Either certificateOrError = EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable & scala.Serializable)() -> Files.readAllBytes(file), ClassTag$.MODULE$.apply(IOException.class), NotNull$.MODULE$.catsNotNullForA()).flatMap((Function1 & Serializable & scala.Serializable)bytes -> MODULE$.x509CertificateFromBytes((byte[])bytes));
            certificateOrError.fold((Function1 & Serializable & scala.Serializable)x$3 -> {
                TrustManagers$.$anonfun$trustManagerFromCertificatePath$5(file, x$3);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)x$4 -> {
                TrustManagers$.$anonfun$trustManagerFromCertificatePath$6(file, x$4);
                return BoxedUnit.UNIT;
            });
            return certificateOrError.toSeq();
        }).toSeq()));
    }

    private Option<X509TrustManager> trustManagerFromEnvVar$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.trustManagerFromEnvVar = Option$.MODULE$.apply((Object)System.getenv("https_cert_path")).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("https_certs_path"))).map((Function1 & Serializable & scala.Serializable)string -> {
                    Path path;
                    block0: {
                        path = Paths.get(string, new String[0]);
                        if (!MODULE$.logger().isDebugEnabled()) break block0;
                        MODULE$.logger().debug(new StringBuilder(17).append("https_cert_path: ").append(path).toString());
                    }
                    return MODULE$.trustManagerFromCertificatePath(path);
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.trustManagerFromEnvVar;
    }

    public Option<X509TrustManager> trustManagerFromEnvVar() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.trustManagerFromEnvVar$lzycompute();
        }
        return this.trustManagerFromEnvVar;
    }

    private X509TrustManager jreTrustManagerWithEnvVar$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.jreTrustManagerWithEnvVar = (X509TrustManager)Semigroup$.MODULE$.maybeCombine((Object)this.jreTrustManager(), this.trustManagerFromEnvVar(), this.trustManagerSemigroup());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.jreTrustManagerWithEnvVar;
    }

    public X509TrustManager jreTrustManagerWithEnvVar() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.jreTrustManagerWithEnvVar$lzycompute();
        }
        return this.jreTrustManagerWithEnvVar;
    }

    private Option<X509TrustManager> insecureTrustManagerFromEnvVar$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.insecureTrustManagerFromEnvVar = Option$.MODULE$.apply((Object)System.getenv("https_insecure")).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.equalsIgnoreCase("true"))).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.insecureTrustManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.insecureTrustManagerFromEnvVar;
    }

    public Option<X509TrustManager> insecureTrustManagerFromEnvVar() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.insecureTrustManagerFromEnvVar$lzycompute();
        }
        return this.insecureTrustManagerFromEnvVar;
    }

    private static final /* synthetic */ String trustStoreType$lzycompute$1(LazyRef trustStoreType$lzy$1) {
        String string;
        LazyRef lazyRef = trustStoreType$lzy$1;
        synchronized (lazyRef) {
            string = trustStoreType$lzy$1.initialized() ? (String)trustStoreType$lzy$1.value() : (String)trustStoreType$lzy$1.initialize(Option$.MODULE$.apply((Object)System.getProperty("javax.net.ssl.trustStoreType")).getOrElse((Function0 & Serializable & scala.Serializable)() -> KeyStore.getDefaultType()));
        }
        return string;
    }

    private static final String trustStoreType$1(LazyRef trustStoreType$lzy$1) {
        if (trustStoreType$lzy$1.initialized()) {
            return (String)trustStoreType$lzy$1.value();
        }
        return TrustManagers$.trustStoreType$lzycompute$1(trustStoreType$lzy$1);
    }

    private static final /* synthetic */ Option trustStoreProvider$lzycompute$1(LazyRef trustStoreProvider$lzy$1) {
        Option option;
        LazyRef lazyRef = trustStoreProvider$lzy$1;
        synchronized (lazyRef) {
            option = trustStoreProvider$lzy$1.initialized() ? (Option)trustStoreProvider$lzy$1.value() : (Option)trustStoreProvider$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)System.getProperty("javax.net.ssl.trustStoreProvider")));
        }
        return option;
    }

    private static final Option trustStoreProvider$1(LazyRef trustStoreProvider$lzy$1) {
        if (trustStoreProvider$lzy$1.initialized()) {
            return (Option)trustStoreProvider$lzy$1.value();
        }
        return TrustManagers$.trustStoreProvider$lzycompute$1(trustStoreProvider$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$jreTrustManager$2(String x$1) {
        String string = x$1;
        String string2 = "NONE";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final /* synthetic */ Option trustStore$lzycompute$1(LazyRef trustStore$lzy$1) {
        Option option;
        LazyRef lazyRef = trustStore$lzy$1;
        synchronized (lazyRef) {
            option = trustStore$lzy$1.initialized() ? (Option)trustStore$lzy$1.value() : (Option)trustStore$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)System.getProperty("javax.net.ssl.trustStore")).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TrustManagers$.$anonfun$jreTrustManager$2(x$1))));
        }
        return option;
    }

    private static final Option trustStore$1(LazyRef trustStore$lzy$1) {
        if (trustStore$lzy$1.initialized()) {
            return (Option)trustStore$lzy$1.value();
        }
        return TrustManagers$.trustStore$lzycompute$1(trustStore$lzy$1);
    }

    private static final /* synthetic */ Option trustStorePassword$lzycompute$1(LazyRef trustStorePassword$lzy$1) {
        Option option;
        LazyRef lazyRef = trustStorePassword$lzy$1;
        synchronized (lazyRef) {
            option = trustStorePassword$lzy$1.initialized() ? (Option)trustStorePassword$lzy$1.value() : (Option)trustStorePassword$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)System.getProperty("javax.net.ssl.trustStorePassword")).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toCharArray()));
        }
        return option;
    }

    private static final Option trustStorePassword$1(LazyRef trustStorePassword$lzy$1) {
        if (trustStorePassword$lzy$1.initialized()) {
            return (Option)trustStorePassword$lzy$1.value();
        }
        return TrustManagers$.trustStorePassword$lzycompute$1(trustStorePassword$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$keyStoreFromCertificates$1(KeyStore keyStore$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Certificate certificate = (Certificate)tuple2._1();
            int i = tuple2._2$mcI$sp();
            keyStore$1.setCertificateEntry(Integer.toString(i), certificate);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$trustManagerFromCertificatePath$1(Path path) {
        return !((Object)path.getFileName()).toString().startsWith(".") && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static final /* synthetic */ void $anonfun$trustManagerFromCertificatePath$5(Path file$1, Exception x$3) {
        if (MODULE$.logger().isWarnEnabled()) {
            MODULE$.logger().warn(new StringBuilder(28).append("Failed to load certificate: ").append(file$1).toString(), (Throwable)x$3);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$trustManagerFromCertificatePath$6(Path file$1, X509Certificate x$4) {
        if (MODULE$.logger().isInfoEnabled()) {
            MODULE$.logger().info(new StringBuilder(20).append("Loaded certificate: ").append(file$1).toString());
            return;
        }
    }

    private TrustManagers$() {
        MODULE$ = this;
        this.insecureTrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        this.trustManagerSemigroup = Semigroup$.MODULE$.instance((Function2 & Serializable & scala.Serializable)(trustManager1, trustManager2) -> new X509TrustManager((X509TrustManager)trustManager1, (X509TrustManager)trustManager2){
            private final X509TrustManager trustManager1$1;
            private final X509TrustManager trustManager2$1;

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                try {
                    this.trustManager1$1.checkClientTrusted(chain, authType);
                }
                catch (CertificateException certificateException1) {
                    try {
                        this.trustManager2$1.checkClientTrusted(chain, authType);
                    }
                    catch (CertificateException certificateException2) {
                        certificateException2.addSuppressed(certificateException1);
                        throw certificateException2;
                    }
                }
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                try {
                    this.trustManager1$1.checkServerTrusted(chain, authType);
                }
                catch (CertificateException certificateException1) {
                    try {
                        this.trustManager2$1.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException certificateException2) {
                        certificateException2.addSuppressed(certificateException1);
                        throw certificateException2;
                    }
                }
            }

            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trustManager1$1.getAcceptedIssuers())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trustManager2$1.getAcceptedIssuers())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(X509Certificate.class)));
            }
            {
                this.trustManager1$1 = trustManager1$1;
                this.trustManager2$1 = trustManager2$1;
            }
        });
        this.logger = LoggerFactory.getLogger((String)"de.lhns.trustmanager.TrustManagers");
    }
}

