/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.trustmanager;

import cats.NotNull$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import de.lolhens.trustmanager.TrustManagers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Either;

public final class TrustManagers$ {
    public static TrustManagers$ MODULE$;
    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager;
    private final X509TrustManager insecureTrustManager;
    private final Semigroup<X509TrustManager> trustManagerSemigroup;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TrustManagers$();
    }

    public X509TrustManager insecureTrustManager() {
        return this.insecureTrustManager;
    }

    public Semigroup<X509TrustManager> trustManagerSemigroup() {
        return this.trustManagerSemigroup;
    }

    public X509TrustManager trustManagerFromKeyStore(KeyStore keyStore) {
        X509TrustManager x509TrustManager;
        Object object = new Object();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManagerFactory.getTrustManagers())).foreach((Function1 & Serializable & scala.Serializable)trustManager -> {
                TrustManager trustManager2 = trustManager;
                if (trustManager2 instanceof X509TrustManager) {
                    X509TrustManager x509TrustManager = (X509TrustManager)trustManager2;
                    throw new NonLocalReturnControl(object, (Object)x509TrustManager);
                }
                throw new MatchError((Object)trustManager2);
            });
            x509TrustManager = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                x509TrustManager = (X509TrustManager)ex.value();
            }
            throw ex;
        }
        return x509TrustManager;
    }

    public X509TrustManager jreTrustManager() {
        return this.trustManagerFromKeyStore(null);
    }

    public X509TrustManager defaultTrustManager() {
        return this.jreTrustManager();
    }

    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager$lzycompute() {
        TrustManagers$ trustManagers$ = this;
        synchronized (trustManagers$) {
            if (!this.bitmap$0) {
                this.defaultThreadSafeTrustManager = new TrustManagers.ThreadSafeX509TrustManager(this.jreTrustManager());
                this.bitmap$0 = true;
            }
        }
        return this.defaultThreadSafeTrustManager;
    }

    private TrustManagers.ThreadSafeX509TrustManager defaultThreadSafeTrustManager() {
        return !this.bitmap$0 ? this.defaultThreadSafeTrustManager$lzycompute() : this.defaultThreadSafeTrustManager;
    }

    /*
     * WARNING - void declaration
     */
    private SSLContext sslContext(X509TrustManager trustManager) {
        void var2_2;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{trustManager}), null);
        return var2_2;
    }

    public void setDefaultTrustManager(X509TrustManager trustManager) {
        this.defaultThreadSafeTrustManager().set(trustManager);
        SSLContext.setDefault(this.sslContext(this.defaultThreadSafeTrustManager()));
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore keyStoreFromCertificates(Seq<Certificate> certificates) {
        void var2_2;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char()));
        ((IterableLike)certificates.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TrustManagers$.$anonfun$keyStoreFromCertificates$1(keyStore, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Either<CertificateException, X509Certificate> x509CertificateFromBytes(byte[] bytes) {
        return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable & scala.Serializable)() -> (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(bytes)), ClassTag$.MODULE$.apply(CertificateException.class), NotNull$.MODULE$.catsNotNullForA());
    }

    private Logger logger() {
        return this.logger;
    }

    public X509TrustManager trustManagerFromCertificatePath(Path path) {
        return this.trustManagerFromKeyStore(this.keyStoreFromCertificates((Seq<Certificate>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(path).iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TrustManagers$.$anonfun$trustManagerFromCertificatePath$1(x$1))).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Either certificateOrError = EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either())), (Function0 & Serializable & scala.Serializable)() -> Files.readAllBytes(file), ClassTag$.MODULE$.apply(IOException.class), NotNull$.MODULE$.catsNotNullForA()).flatMap((Function1 & Serializable & scala.Serializable)bytes -> MODULE$.x509CertificateFromBytes((byte[])bytes));
            certificateOrError.fold((Function1 & Serializable & scala.Serializable)x$2 -> {
                TrustManagers$.$anonfun$trustManagerFromCertificatePath$5(file, x$2);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)x$3 -> {
                TrustManagers$.$anonfun$trustManagerFromCertificatePath$6(file, x$3);
                return BoxedUnit.UNIT;
            });
            return certificateOrError.toSeq();
        }).toSeq()));
    }

    public static final /* synthetic */ void $anonfun$keyStoreFromCertificates$1(KeyStore keyStore$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Certificate certificate = (Certificate)tuple2._1();
        int i = tuple2._2$mcI$sp();
        keyStore$1.setCertificateEntry(Integer.toString(i), certificate);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$trustManagerFromCertificatePath$1(Path x$1) {
        return Files.isRegularFile(x$1, new LinkOption[0]);
    }

    public static final /* synthetic */ void $anonfun$trustManagerFromCertificatePath$5(Path file$1, Exception x$2) {
        block0: {
            if (!MODULE$.logger().isWarnEnabled()) break block0;
            MODULE$.logger().warn(new StringBuilder(28).append("Failed to load certificate: ").append(file$1).toString(), (Throwable)x$2);
        }
    }

    public static final /* synthetic */ void $anonfun$trustManagerFromCertificatePath$6(Path file$1, X509Certificate x$3) {
        block0: {
            if (!MODULE$.logger().isInfoEnabled()) break block0;
            MODULE$.logger().info(new StringBuilder(20).append("Loaded certificate: ").append(file$1).toString());
        }
    }

    private TrustManagers$() {
        MODULE$ = this;
        this.insecureTrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        this.trustManagerSemigroup = Semigroup$.MODULE$.instance((Function2 & Serializable & scala.Serializable)(trustManager1, trustManager2) -> new X509TrustManager((X509TrustManager)trustManager1, (X509TrustManager)trustManager2){
            private final X509TrustManager trustManager1$1;
            private final X509TrustManager trustManager2$1;

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                try {
                    this.trustManager1$1.checkClientTrusted(chain, authType);
                }
                catch (CertificateException certificateException1) {
                    try {
                        this.trustManager2$1.checkClientTrusted(chain, authType);
                    }
                    catch (CertificateException certificateException2) {
                        certificateException2.addSuppressed(certificateException1);
                        throw certificateException2;
                    }
                }
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                try {
                    this.trustManager1$1.checkServerTrusted(chain, authType);
                }
                catch (CertificateException certificateException1) {
                    try {
                        this.trustManager2$1.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException certificateException2) {
                        certificateException2.addSuppressed(certificateException1);
                        throw certificateException2;
                    }
                }
            }

            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trustManager1$1.getAcceptedIssuers())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trustManager2$1.getAcceptedIssuers())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(X509Certificate.class)));
            }
            {
                this.trustManager1$1 = trustManager1$1;
                this.trustManager2$1 = trustManager2$1;
            }
        });
        this.logger = LoggerFactory.getLogger((String)"de.lolhens.trustmanager.TrustManagers");
    }
}

