/*
 * Decompiled with CFR 0.152.
 */
package jp.t2v.lab.play2.auth.social.providers.slack;

import java.io.Serializable;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Singleton;
import jp.t2v.lab.play2.auth.social.core.AccessTokenRetrievalFailedException;
import jp.t2v.lab.play2.auth.social.core.OAuth2Authenticator;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.http.MimeTypes$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.EmptyBody$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u000b\u0017\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005m!A!\t\u0001B\u0001B\u0003%1\tC\u0003H\u0001\u0011\u0005\u0001*\u0002\u0003W\u0001\u00019\u0006b\u00022\u0001\u0005\u0004%\te\u0019\u0005\u0007I\u0002\u0001\u000b\u0011B,\t\u000f\u0015\u0004!\u0019!C!G\"1a\r\u0001Q\u0001\n]Cqa\u001a\u0001C\u0002\u0013\u00053\r\u0003\u0004i\u0001\u0001\u0006Ia\u0016\u0005\bS\u0002\u0011\r\u0011\"\u0011d\u0011\u0019Q\u0007\u0001)A\u0005/\"91\u000e\u0001b\u0001\n\u0003\u001a\u0007B\u00027\u0001A\u0003%q\u000bC\u0004n\u0001\t\u0007I\u0011I2\t\r9\u0004\u0001\u0015!\u0003X\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\ty\u0001\u0001C!\u0003#\u0011!c\u00157bG.\fU\u000f\u001e5f]RL7-\u0019;pe*\u0011q\u0003G\u0001\u0006g2\f7m\u001b\u0006\u00033i\t\u0011\u0002\u001d:pm&$WM]:\u000b\u0005ma\u0012AB:pG&\fGN\u0003\u0002\u001e=\u0005!\u0011-\u001e;i\u0015\ty\u0002%A\u0003qY\u0006L(G\u0003\u0002\"E\u0005\u0019A.\u00192\u000b\u0005\r\"\u0013a\u0001;3m*\tQ%\u0001\u0002ka\u000e\u00011c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001a\u000e\u0003AR!!\r\u000e\u0002\t\r|'/Z\u0005\u0003gA\u00121cT!vi\"\u0014\u0014)\u001e;iK:$\u0018nY1u_J\f!a^:\u0016\u0003Y\u0002\"aN \u000e\u0003aR!\u0001N\u001d\u000b\u0005iZ\u0014\u0001\u00027jENT!\u0001P\u001f\u0002\u0007\u0005\u0004\u0018NC\u0001?\u0003\u0011\u0001H.Y=\n\u0005\u0001C$\u0001C,T\u00072LWM\u001c;\u0002\u0007]\u001c\b%\u0001\u0004d_:4\u0017n\u001a\t\u0003\t\u0016k\u0011aO\u0005\u0003\rn\u0012QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002J\u00172\u0003\"A\u0013\u0001\u000e\u0003YAQ\u0001\u000e\u0003A\u0002YBQA\u0011\u0003A\u0002\rC#\u0001\u0002(\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016AB5oU\u0016\u001cGOC\u0001T\u0003\u0015Q\u0017M^1y\u0013\t)\u0006K\u0001\u0004J]*,7\r\u001e\u0002\f\u0003\u000e\u001cWm]:U_.,g\u000e\u0005\u0002Y?:\u0011\u0011,\u0018\t\u00035*j\u0011a\u0017\u0006\u00039\u001a\na\u0001\u0010:p_Rt\u0014B\u00010+\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yS\u0013\u0001\u00049s_ZLG-\u001a:OC6,W#A,\u0002\u001bA\u0014xN^5eKJt\u0015-\\3!\u0003A\tW\u000f\u001e5pe&T\u0018\r^5p]V\u0013H.A\tbkRDwN]5{CRLwN\\+sY\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013H.A\bbG\u000e,7o\u001d+pW\u0016tWK\u001d7!\u0003!\u0019G.[3oi&#\u0017!C2mS\u0016tG/\u00133!\u00031\u0019G.[3oiN+7M]3u\u00035\u0019G.[3oiN+7M]3uA\u0005Y1-\u00197mE\u0006\u001c7.\u0016:m\u00031\u0019\u0017\r\u001c7cC\u000e\\WK\u001d7!\u0003M9W\r^!vi\"|'/\u001b>bi&|g.\u0016:m)\r9\u0016o\u001d\u0005\u0006eJ\u0001\raV\u0001\u0006g\u000e|\u0007/\u001a\u0005\u0006iJ\u0001\raV\u0001\u0006gR\fG/Z\u0001\u0014e\u0016$(/[3wK\u0006\u001b7-Z:t)>\\WM\u001c\u000b\u0004o\u0006-Ac\u0001=\u0002\u0002A\u0019\u0011\u0010 @\u000e\u0003iT!a\u001f\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002~u\n1a)\u001e;ve\u0016\u0004\"a`\u0003\u000e\u0003\u0001Aq!a\u0001\u0014\u0001\b\t)!A\u0002dib\u00042!_A\u0004\u0013\r\tIA\u001f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDa!!\u0004\u0014\u0001\u00049\u0016\u0001B2pI\u0016\f\u0001\u0004]1sg\u0016\f5mY3tgR{7.\u001a8SKN\u0004xN\\:f)\rq\u00181\u0003\u0005\b\u0003+!\u0002\u0019AA\f\u0003!\u0011Xm\u001d9p]N,\u0007cA\u001c\u0002\u001a%\u0019\u00111\u0004\u001d\u0003\u0015]\u001b&+Z:q_:\u001cX\rK\u0002\u0001\u0003?\u00012aTA\u0011\u0013\r\t\u0019\u0003\u0015\u0002\n'&tw\r\\3u_:\u0004")
public class SlackAuthenticator
implements OAuth2Authenticator {
    private final WSClient ws;
    private final String providerName;
    private final String authorizationUrl;
    private final String accessTokenUrl;
    private final String clientId;
    private final String clientSecret;
    private final String callbackUrl;

    @Override
    public WSClient ws() {
        return this.ws;
    }

    @Override
    public String providerName() {
        return this.providerName;
    }

    @Override
    public String authorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public String accessTokenUrl() {
        return this.accessTokenUrl;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    public String callbackUrl() {
        return this.callbackUrl;
    }

    @Override
    public String getAuthorizationUrl(String scope, String state) {
        String encodedClientId = URLEncoder.encode(this.clientId(), "utf-8");
        String encodedRedirectUri = URLEncoder.encode(this.callbackUrl(), "utf-8");
        String encodedScope = URLEncoder.encode(scope, "utf-8");
        String encodedState = URLEncoder.encode(state, "utf-8");
        return new StringBuilder(39).append(this.authorizationUrl()).append("?client_id=").append(encodedClientId).append("&redirect_uri=").append(encodedRedirectUri).append("&scope=").append(encodedScope).append("&state=").append(encodedState).toString();
    }

    public Future<String> retrieveAccessToken(String code, ExecutionContext ctx) {
        return this.ws().url(this.accessTokenUrl()).withQueryStringParameters((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)this.clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)this.clientSecret()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri"), (Object)this.callbackUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)code)})).withHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCEPT()), (Object)MimeTypes$.MODULE$.JSON())})).post((Object)EmptyBody$.MODULE$, package$.MODULE$.writeableOf_WsBody()).map((Function1 & Serializable & scala.Serializable)response -> {
            Logger$.MODULE$.apply(this.getClass()).debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Retrieving access token from provider API: ").append(response.body()).toString(), MarkerContext$.MODULE$.NoMarker());
            return this.parseAccessTokenResponse((WSResponse)response);
        }, ctx);
    }

    @Override
    public String parseAccessTokenResponse(WSResponse response) {
        String string;
        JsValue j = response.json();
        try {
            string = (String)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(j), "access_token").as((Reads)Reads$.MODULE$.StringReads());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new AccessTokenRetrievalFailedException("Failed to retrieve access token", e);
            }
            throw throwable;
        }
        return string;
    }

    @Inject
    public SlackAuthenticator(WSClient ws, Configuration config) {
        this.ws = ws;
        this.providerName = "slack";
        this.authorizationUrl = "https://slack.com/oauth/authorize";
        this.accessTokenUrl = "https://slack.com/api/oauth.access";
        this.clientId = (String)config.get("slack.clientId", ConfigLoader$.MODULE$.stringLoader());
        this.clientSecret = (String)config.get("slack.clientSecret", ConfigLoader$.MODULE$.stringLoader());
        this.callbackUrl = (String)config.get("slack.callbackURL", ConfigLoader$.MODULE$.stringLoader());
    }
}

