/*
 * Decompiled with CFR 0.152.
 */
package jp.t2v.lab.play2.auth.social.providers.github;

import java.io.Serializable;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Singleton;
import jp.t2v.lab.play2.auth.social.core.AccessTokenRetrievalFailedException;
import jp.t2v.lab.play2.auth.social.core.OAuth2Authenticator;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.http.MimeTypes$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.EmptyBody$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\n\u0014\u0001\u0011B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t}\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003E\u0001\u0011\u0005Q)\u0002\u0003T\u0001\u0001!\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007C\u0002\u0001\u000b\u0011\u0002+\t\u000f\t\u0004!\u0019!C\u0001G\"11\u000e\u0001Q\u0001\n\u0011Dq\u0001\u001c\u0001C\u0002\u0013\u00051\r\u0003\u0004n\u0001\u0001\u0006I\u0001\u001a\u0005\t]\u0002A)\u0019!C\u0001A\"Aq\u000e\u0001EC\u0002\u0013\u0005\u0001\r\u0003\u0005q\u0001!\u0015\r\u0011\"\u0001a\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!a\u0005\u0001\t\u0003\t)BA\nHSRDUOY!vi\",g\u000e^5dCR|'O\u0003\u0002\u0015+\u00051q-\u001b;ik\nT!AF\f\u0002\u0013A\u0014xN^5eKJ\u001c(B\u0001\r\u001a\u0003\u0019\u0019xnY5bY*\u0011!dG\u0001\u0005CV$\bN\u0003\u0002\u001d;\u0005)\u0001\u000f\\1ze)\u0011adH\u0001\u0004Y\u0006\u0014'B\u0001\u0011\"\u0003\r!(G\u001e\u0006\u0002E\u0005\u0011!\u000e]\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051zS\"A\u0017\u000b\u00059:\u0012\u0001B2pe\u0016L!\u0001M\u0017\u0003'=\u000bU\u000f\u001e53\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u0005]\u001cX#A\u001a\u0011\u0005QbT\"A\u001b\u000b\u0005E2$BA\u001c9\u0003\u0011a\u0017NY:\u000b\u0005eR\u0014aA1qS*\t1(\u0001\u0003qY\u0006L\u0018BA\u001f6\u0005!96k\u00117jK:$\u0018aA<tA\u000511m\u001c8gS\u001e\u0004\"!\u0011\"\u000e\u0003aJ!a\u0011\u001d\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019a\tS%\u0011\u0005\u001d\u0003Q\"A\n\t\u000bE\"\u0001\u0019A\u001a\t\u000b}\"\u0001\u0019\u0001!)\u0005\u0011Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0019IgN[3di*\t\u0001+A\u0003kCZ\f\u00070\u0003\u0002S\u001b\n1\u0011J\u001c6fGR\u00141\"Q2dKN\u001cHk\\6f]B\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u0014\u000e\u0003aS!!W\u0012\u0002\rq\u0012xn\u001c;?\u0013\tYv%\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.(\u00031\u0001(o\u001c<jI\u0016\u0014h*Y7f+\u0005!\u0016!\u00049s_ZLG-\u001a:OC6,\u0007%\u0001\bbG\u000e,7o\u001d+pW\u0016tWK\u001d7\u0016\u0003\u0011\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t1\fgn\u001a\u0006\u0002S\u0006!!.\u0019<b\u0013\tif-A\bbG\u000e,7o\u001d+pW\u0016tWK\u001d7!\u0003A\tW\u000f\u001e5pe&T\u0018\r^5p]V\u0013H.A\tbkRDwN]5{CRLwN\\+sY\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\rG2LWM\u001c;TK\u000e\u0014X\r^\u0001\fG\u0006dGNY1dWV\u0013H.A\nsKR\u0014\u0018.\u001a<f\u0003\u000e\u001cWm]:U_.,g\u000eF\u0002t\u0003\u0007!\"\u0001\u001e?\u0011\u0007UD(0D\u0001w\u0015\t9x%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001f<\u0003\r\u0019+H/\u001e:f!\tYX!D\u0001\u0001\u0011\u0015ix\u0002q\u0001\u007f\u0003\r\u0019G\u000f\u001f\t\u0003k~L1!!\u0001w\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0006=\u0001\r\u0001V\u0001\u0005G>$W-A\nhKR\fU\u000f\u001e5pe&T\u0018\r^5p]V\u0013H\u000eF\u0003U\u0003\u0017\ty\u0001\u0003\u0004\u0002\u000eA\u0001\r\u0001V\u0001\u0006g\u000e|\u0007/\u001a\u0005\u0007\u0003#\u0001\u0002\u0019\u0001+\u0002\u000bM$\u0018\r^3\u00021A\f'o]3BG\u000e,7o\u001d+pW\u0016t'+Z:q_:\u001cX\rF\u0002U\u0003/Aq!!\u0007\u0012\u0001\u0004\tY\"\u0001\u0005sKN\u0004xN\\:f!\r!\u0014QD\u0005\u0004\u0003?)$AC,T%\u0016\u001c\bo\u001c8tK\"\u001a\u0001!a\t\u0011\u00071\u000b)#C\u0002\u0002(5\u0013\u0011bU5oO2,Go\u001c8")
public class GitHubAuthenticator
implements OAuth2Authenticator {
    private String clientId;
    private String clientSecret;
    private String callbackUrl;
    private final WSClient ws;
    private final Configuration config;
    private final String providerName;
    private final String accessTokenUrl;
    private final String authorizationUrl;
    private volatile byte bitmap$0;

    @Override
    public WSClient ws() {
        return this.ws;
    }

    @Override
    public String providerName() {
        return this.providerName;
    }

    @Override
    public String accessTokenUrl() {
        return this.accessTokenUrl;
    }

    @Override
    public String authorizationUrl() {
        return this.authorizationUrl;
    }

    private String clientId$lzycompute() {
        GitHubAuthenticator gitHubAuthenticator = this;
        synchronized (gitHubAuthenticator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.clientId = (String)this.config.get("github.clientId", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.clientId;
    }

    @Override
    public String clientId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.clientId$lzycompute() : this.clientId;
    }

    private String clientSecret$lzycompute() {
        GitHubAuthenticator gitHubAuthenticator = this;
        synchronized (gitHubAuthenticator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.clientSecret = (String)this.config.get("github.clientSecret", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.clientSecret;
    }

    @Override
    public String clientSecret() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.clientSecret$lzycompute() : this.clientSecret;
    }

    private String callbackUrl$lzycompute() {
        GitHubAuthenticator gitHubAuthenticator = this;
        synchronized (gitHubAuthenticator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.callbackUrl = (String)this.config.get("github.callbackURL", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.callbackUrl;
    }

    @Override
    public String callbackUrl() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.callbackUrl$lzycompute() : this.callbackUrl;
    }

    public Future<String> retrieveAccessToken(String code, ExecutionContext ctx) {
        return this.ws().url(this.accessTokenUrl()).withQueryStringParameters((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)this.clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)this.clientSecret()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)code)})).withHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCEPT()), (Object)MimeTypes$.MODULE$.JSON())})).post((Object)EmptyBody$.MODULE$, package$.MODULE$.writeableOf_WsBody()).map((Function1 & Serializable & scala.Serializable)response -> {
            Logger$.MODULE$.apply(this.getClass()).debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Retrieving access token from provider API: ").append(response.body()).toString(), MarkerContext$.MODULE$.NoMarker());
            return this.parseAccessTokenResponse((WSResponse)response);
        }, ctx);
    }

    @Override
    public String getAuthorizationUrl(String scope, String state) {
        String encodedClientId = URLEncoder.encode(this.clientId(), "utf-8");
        String encodedRedirectUri = URLEncoder.encode(this.callbackUrl(), "utf-8");
        String encodedScope = URLEncoder.encode(scope, "utf-8");
        String encodedState = URLEncoder.encode(state, "utf-8");
        return new StringBuilder(39).append(this.authorizationUrl()).append("?client_id=").append(encodedClientId).append("&redirect_uri=").append(encodedRedirectUri).append("&scope=").append(encodedScope).append("&state=").append(encodedState).toString();
    }

    @Override
    public String parseAccessTokenResponse(WSResponse response) {
        String string;
        Logger$.MODULE$.apply(this.getClass()).debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Parsing access token response: ").append(response.body()).toString(), MarkerContext$.MODULE$.NoMarker());
        try {
            string = (String)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(response.json()), "access_token").as((Reads)Reads$.MODULE$.StringReads());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new AccessTokenRetrievalFailedException(new StringBuilder(30).append("Failed to parse access token: ").append(response.body()).toString(), e);
            }
            throw throwable;
        }
        return string;
    }

    @Inject
    public GitHubAuthenticator(WSClient ws, Configuration config) {
        this.ws = ws;
        this.config = config;
        this.providerName = "github";
        this.accessTokenUrl = "https://github.com/login/oauth/access_token";
        this.authorizationUrl = "https://github.com/login/oauth/authorize";
    }
}

