/*
 * Decompiled with CFR 0.152.
 */
package de.lkv.nrw.adisparser;

import de.lkv.nrw.adisparser.AdisLine;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a8\u0006\r"}, d2={"Lde/lkv/nrw/adisparser/AdisParser;", "", "()V", "readFile", "Ljava/util/LinkedList;", "Lde/lkv/nrw/adisparser/AdisLine;", "file", "Ljava/io/File;", "charset", "", "readList", "lines", "Companion", "adisparser"})
public final class AdisParser {
    private static final String DEFAULT_CHARSET = "ISO-8859-15";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LinkedList<AdisLine> readFile(@NotNull File file, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        if (!file.exists()) {
            throw (Throwable)new NoSuchFileException(file, null, "The given file does not exist");
        }
        if (file.exists() && !file.isFile()) {
            throw (Throwable)new NoSuchFileException(file, null, "The given file appears to be a directory");
        }
        LinkedList<AdisLine> list = new LinkedList<AdisLine>();
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charset)");
        for (String line : FilesKt.readLines((File)file, (Charset)charset2)) {
            list.add(AdisLine.Companion.parse(line));
        }
        return list;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LinkedList readFile$default(AdisParser adisParser, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = DEFAULT_CHARSET;
        }
        return adisParser.readFile(file, string);
    }

    @NotNull
    public final LinkedList<AdisLine> readList(@NotNull LinkedList<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        LinkedList<AdisLine> list = new LinkedList<AdisLine>();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            String string = line = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
            list.add(AdisLine.Companion.parse(string));
        }
        return list;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/lkv/nrw/adisparser/AdisParser$Companion;", "", "()V", "DEFAULT_CHARSET", "", "adisparser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

