/*
 * Decompiled with CFR 0.152.
 */
package de.lkv.nrw.adisparser;

import de.lkv.nrw.adisparser.AdisCommandLine;
import de.lkv.nrw.adisparser.AdisCommentLine;
import de.lkv.nrw.adisparser.AdisDefinitionLine;
import de.lkv.nrw.adisparser.AdisPropertyLine;
import de.lkv.nrw.adisparser.AdisValueLine;
import de.lkv.nrw.adisparser.exceptions.DefinitionTypeMissingException;
import de.lkv.nrw.adisparser.exceptions.LineCategoryUnknownException;
import de.lkv.nrw.adisparser.exceptions.NoTypeAssignmentFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lde/lkv/nrw/adisparser/AdisLine;", "", "line", "", "type", "Lde/lkv/nrw/adisparser/AdisLine$LineType;", "(Ljava/lang/String;Lde/lkv/nrw/adisparser/AdisLine$LineType;)V", "category", "Lde/lkv/nrw/adisparser/AdisLine$LineCategory;", "getCategory$adisparser", "()Lde/lkv/nrw/adisparser/AdisLine$LineCategory;", "setCategory$adisparser", "(Lde/lkv/nrw/adisparser/AdisLine$LineCategory;)V", "Companion", "LineCategory", "LineType", "adisparser"})
public class AdisLine {
    @NotNull
    private LineCategory category;
    @Nullable
    private static AdisLine defLine;
    public static final Companion Companion;

    @NotNull
    public final LineCategory getCategory$adisparser() {
        return this.category;
    }

    public final void setCategory$adisparser(@NotNull LineCategory lineCategory) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lineCategory), (String)"<set-?>");
        this.category = lineCategory;
    }

    public AdisLine(@NotNull String line, @NotNull LineType type) {
        boolean bl;
        String sub;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            String string = line;
            int n = 0;
            int n2 = 2;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            sub = string2;
            List<LineCategory> headers = LineCategory.Companion.valuesOf(type);
            Iterable $receiver$iv = headers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    LineCategory it = (LineCategory)((Object)element$iv);
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)sub)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            throw (Throwable)new LineCategoryUnknownException("Line does not appear to be a valid adis line of type: " + type.name());
        }
        this.category = LineCategory.valueOf(sub);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0080\u0001\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Lde/lkv/nrw/adisparser/AdisLine$LineCategory;", "", "type", "Lde/lkv/nrw/adisparser/AdisLine$LineType;", "(Ljava/lang/String;ILde/lkv/nrw/adisparser/AdisLine$LineType;)V", "getType$adisparser", "()Lde/lkv/nrw/adisparser/AdisLine$LineType;", "setType$adisparser", "(Lde/lkv/nrw/adisparser/AdisLine$LineType;)V", "DH", "VH", "DN", "VN", "PO", "PN", "PR", "QO", "QN", "QR", "TN", "EN", "ZN", "CN", "CF", "Companion", "adisparser"})
    public static final class LineCategory
    extends Enum<LineCategory> {
        public static final /* enum */ LineCategory DH;
        public static final /* enum */ LineCategory VH;
        public static final /* enum */ LineCategory DN;
        public static final /* enum */ LineCategory VN;
        public static final /* enum */ LineCategory PO;
        public static final /* enum */ LineCategory PN;
        public static final /* enum */ LineCategory PR;
        public static final /* enum */ LineCategory QO;
        public static final /* enum */ LineCategory QN;
        public static final /* enum */ LineCategory QR;
        public static final /* enum */ LineCategory TN;
        public static final /* enum */ LineCategory EN;
        public static final /* enum */ LineCategory ZN;
        public static final /* enum */ LineCategory CN;
        public static final /* enum */ LineCategory CF;
        private static final /* synthetic */ LineCategory[] $VALUES;
        @NotNull
        private LineType type;
        public static final Companion Companion;

        static {
            LineCategory[] lineCategoryArray = new LineCategory[15];
            LineCategory[] lineCategoryArray2 = lineCategoryArray;
            lineCategoryArray[0] = DH = new LineCategory(LineType.DEFINITION);
            lineCategoryArray[1] = VH = new LineCategory(LineType.VALUE);
            lineCategoryArray[2] = DN = new LineCategory(LineType.DEFINITION);
            lineCategoryArray[3] = VN = new LineCategory(LineType.VALUE);
            lineCategoryArray[4] = PO = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[5] = PN = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[6] = PR = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[7] = QO = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[8] = QN = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[9] = QR = new LineCategory(LineType.PROPERTY);
            lineCategoryArray[10] = TN = new LineCategory(LineType.COMMAND);
            lineCategoryArray[11] = EN = new LineCategory(LineType.COMMAND);
            lineCategoryArray[12] = ZN = new LineCategory(LineType.COMMAND);
            lineCategoryArray[13] = CN = new LineCategory(LineType.COMMENT);
            lineCategoryArray[14] = CF = new LineCategory(LineType.COMMENT);
            $VALUES = lineCategoryArray;
            Companion = new Companion(null);
        }

        @NotNull
        public final LineType getType$adisparser() {
            return this.type;
        }

        public final void setType$adisparser(@NotNull LineType lineType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lineType), (String)"<set-?>");
            this.type = lineType;
        }

        protected LineCategory(LineType type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            this.type = type;
        }

        public static LineCategory[] values() {
            return (LineCategory[])$VALUES.clone();
        }

        public static LineCategory valueOf(String string) {
            return Enum.valueOf(LineCategory.class, string);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/lkv/nrw/adisparser/AdisLine$LineCategory$Companion;", "", "()V", "valuesOf", "", "Lde/lkv/nrw/adisparser/AdisLine$LineCategory;", "type", "Lde/lkv/nrw/adisparser/AdisLine$LineType;", "adisparser"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<LineCategory> valuesOf(@NotNull LineType type) {
                void $receiver$iv$iv;
                LineCategory[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                LineCategory[] lineCategoryArray = $receiver$iv = LineCategory.values();
                Collection destination$iv$iv = new ArrayList();
                for (void element$iv$iv : $receiver$iv$iv) {
                    void it = element$iv$iv;
                    if (!(it.getType$adisparser() == type)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lde/lkv/nrw/adisparser/AdisLine$LineType;", "", "(Ljava/lang/String;I)V", "DEFINITION", "VALUE", "COMMENT", "PROPERTY", "COMMAND", "adisparser"})
    public static final class LineType
    extends Enum<LineType> {
        public static final /* enum */ LineType DEFINITION;
        public static final /* enum */ LineType VALUE;
        public static final /* enum */ LineType COMMENT;
        public static final /* enum */ LineType PROPERTY;
        public static final /* enum */ LineType COMMAND;
        private static final /* synthetic */ LineType[] $VALUES;

        static {
            LineType[] lineTypeArray = new LineType[5];
            LineType[] lineTypeArray2 = lineTypeArray;
            lineTypeArray[0] = DEFINITION = new LineType();
            lineTypeArray[1] = VALUE = new LineType();
            lineTypeArray[2] = COMMENT = new LineType();
            lineTypeArray[3] = PROPERTY = new LineType();
            lineTypeArray[4] = COMMAND = new LineType();
            $VALUES = lineTypeArray;
        }

        public static LineType[] values() {
            return (LineType[])$VALUES.clone();
        }

        public static LineType valueOf(String string) {
            return Enum.valueOf(LineType.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lde/lkv/nrw/adisparser/AdisLine$Companion;", "", "()V", "<set-?>", "Lde/lkv/nrw/adisparser/AdisLine;", "defLine", "getDefLine", "()Lde/lkv/nrw/adisparser/AdisLine;", "setDefLine", "(Lde/lkv/nrw/adisparser/AdisLine;)V", "isAdisLine", "", "line", "", "parse", "adisparser"})
    public static final class Companion {
        @Nullable
        public final AdisLine getDefLine() {
            return defLine;
        }

        private final void setDefLine(AdisLine adisLine) {
            defLine = adisLine;
        }

        public final boolean isAdisLine(@NotNull String line) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            if (line.length() < 2) {
                return false;
            }
            String string = line;
            int n = 0;
            int n2 = 2;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String sub = string2;
            try {
                LineCategory.valueOf(sub);
                bl = true;
            }
            catch (IllegalArgumentException ignore) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final AdisLine parse(@NotNull String line) throws LineCategoryUnknownException, DefinitionTypeMissingException, NoTypeAssignmentFoundException {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            if (!this.isAdisLine(line)) {
                throw (Throwable)new LineCategoryUnknownException("Not a valid or known ADIS-Line: '" + line + '\'');
            }
            String string = line;
            int n = 0;
            int n2 = 2;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            LineCategory cat = LineCategory.valueOf(string2);
            if (cat.getType$adisparser() == LineType.DEFINITION) {
                this.setDefLine(new AdisDefinitionLine(line));
                AdisLine adisLine = this.getDefLine();
                if (adisLine == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.lkv.nrw.adisparser.AdisDefinitionLine");
                }
                return (AdisDefinitionLine)adisLine;
            }
            if (cat.getType$adisparser() == LineType.VALUE) {
                if (this.getDefLine() == null) {
                    throw (Throwable)new DefinitionTypeMissingException("A definition line is required before a value line can be parsed.");
                }
                AdisLine adisLine = this.getDefLine();
                if (adisLine == null) {
                    throw new TypeCastException("null cannot be cast to non-null type de.lkv.nrw.adisparser.AdisDefinitionLine");
                }
                return new AdisValueLine(line, (AdisDefinitionLine)adisLine);
            }
            if (cat.getType$adisparser() == LineType.PROPERTY) {
                return new AdisPropertyLine(line);
            }
            if (cat.getType$adisparser() == LineType.COMMAND) {
                return new AdisCommandLine(line);
            }
            if (cat.getType$adisparser() == LineType.COMMENT) {
                return new AdisCommentLine(line);
            }
            throw (Throwable)new NoTypeAssignmentFoundException("Could not find type assignment for line of category: " + cat.name());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

