/*
 * Decompiled with CFR 0.152.
 */
package de.lkv.nrw.adisparser;

import de.lkv.nrw.adisparser.AdisLine;
import de.lkv.nrw.adisparser.Item;
import de.lkv.nrw.adisparser.exceptions.DefinitionLineException;
import de.lkv.nrw.adisparser.helper.Base36;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0006R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lde/lkv/nrw/adisparser/AdisDefinitionLine;", "Lde/lkv/nrw/adisparser/AdisLine;", "line", "", "(Ljava/lang/String;)V", "<set-?>", "", "entity", "getEntity", "()I", "setEntity", "(I)V", "items", "Ljava/util/LinkedHashMap;", "Lde/lkv/nrw/adisparser/Item;", "Lkotlin/collections/LinkedHashMap;", "getItems", "()Ljava/util/LinkedHashMap;", "getValueLength", "adisparser"})
public final class AdisDefinitionLine
extends AdisLine {
    private int entity;
    @NotNull
    private final LinkedHashMap<Integer, Item> items;

    public final int getEntity() {
        return this.entity;
    }

    private final void setEntity(int n) {
        this.entity = n;
    }

    @NotNull
    public final LinkedHashMap<Integer, Item> getItems() {
        return this.items;
    }

    public final int getValueLength() {
        int i = 8;
        for (Item l : this.items.values()) {
            i += l.getLength();
        }
        return i;
    }

    public AdisDefinitionLine(@NotNull String line) {
        CharSequence charSequence;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        super(line, AdisLine.LineType.DEFINITION);
        Object object = this;
        Object object2 = new LinkedHashMap();
        ((AdisDefinitionLine)object).items = object2;
        try {
            String string = line;
            int n2 = 2;
            n = 8;
            object = this;
            String string2 = string.substring(n2, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object2 = string2;
            Integer n3 = Integer.valueOf((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"Integer.valueOf(line.substring(2, 8))");
            ((AdisDefinitionLine)object).entity = n3;
        }
        catch (NumberFormatException e) {
            DefinitionLineException definitionLineException;
            String string = line;
            int n4 = 2;
            int n5 = 8;
            StringBuilder stringBuilder = new StringBuilder().append("Line appears to contain non-numerical symbols at position 2 to 8. Only numerical characters can be at those positions: ");
            object2 = definitionLineException;
            object = definitionLineException;
            String string3 = string.substring(n4, n5);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            ((DefinitionLineException)object2)(stringBuilder.append(string4).toString());
            throw (Throwable)object;
        }
        String string = line;
        n = 8;
        int n6 = line.length();
        String string5 = string.substring(n, n6);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String l = string5;
        while ((charSequence = (CharSequence)l).length() > 0) {
            int res;
            String resStr;
            int len;
            String lenStr;
            int n7;
            int i;
            int n8;
            if (l.length() < 11) {
                throw (Throwable)new DefinitionLineException("Line appears to be to small. End of line is: " + l);
            }
            try {
                String string6 = l;
                int n9 = 0;
                n8 = 8;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n9, n8);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer n10 = Integer.valueOf(string8);
                Intrinsics.checkExpressionValueIsNotNull((Object)n10, (String)"Integer.valueOf(l.substring(0, 8))");
                i = n10;
            }
            catch (NumberFormatException e) {
                DefinitionLineException definitionLineException;
                String string9 = l;
                int n11 = 0;
                n7 = 8;
                StringBuilder stringBuilder = new StringBuilder().append("Line appears to contain non-numerical symbols on an item position. Only numerical characters can declare items: ");
                object2 = definitionLineException;
                object = definitionLineException;
                String string10 = string9;
                if (string10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string11 = string10.substring(n11, n7);
                Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string12 = string11;
                ((DefinitionLineException)object2)(stringBuilder.append(string12).toString());
                throw (Throwable)object;
            }
            String string13 = l;
            n8 = 8;
            n7 = 10;
            String string14 = string13;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string14.substring(n8, n7), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (StringsKt.toIntOrNull((String)lenStr) != null) {
                Integer n12 = Integer.valueOf(lenStr);
                Intrinsics.checkExpressionValueIsNotNull((Object)n12, (String)"Integer.valueOf(lenStr)");
                len = n12;
            } else {
                len = (int)Base36.Companion.base36ToBase10(lenStr);
            }
            String string15 = l;
            int n13 = 10;
            int n14 = 11;
            String string16 = string15;
            if (string16 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string16.substring(n13, n14), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (StringsKt.toIntOrNull((String)resStr) != null) {
                Integer n15 = Integer.valueOf(resStr);
                Intrinsics.checkExpressionValueIsNotNull((Object)n15, (String)"Integer.valueOf(resStr)");
                res = n15;
            } else {
                res = (int)Base36.Companion.base36ToBase10(lenStr);
            }
            Item item = new Item(i, len, res, null);
            Object object3 = this.items;
            Integer n16 = i;
            Item item2 = item;
            object3.put(n16, item2);
            object3 = l;
            n14 = 11;
            int n17 = l.length();
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object4).substring(n14, n17), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
    }
}

