/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.test.scheduling.util;

import de.lise.fluxflow.test.scheduling.util.BusyWait;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB@\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c2\u0003J$\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\fH\u00c2\u0003JN\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042#\b\u0002\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0013\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/lise/fluxflow/test/scheduling/util/BusyWait;", "T", "", "provider", "Lkotlin/Function0;", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "", "backoffMillis", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;J)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "waitFor", "duration", "Ljava/time/temporal/TemporalAmount;", "(Ljava/time/temporal/TemporalAmount;)Ljava/lang/Object;", "waitForSeconds", "(I)Ljava/lang/Object;", "Companion", "test-scheduling"})
public final class BusyWait<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<T> provider;
    @NotNull
    private final Function1<T, Boolean> condition;
    private final long backoffMillis;

    public BusyWait(@NotNull Function0<? extends T> provider, @NotNull Function1<? super T, Boolean> condition, long backoffMillis) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.provider = provider;
        this.condition = condition;
        this.backoffMillis = backoffMillis;
    }

    public /* synthetic */ BusyWait(Function0 function0, Function1 function1, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 100L;
        }
        this(function0, function1, l);
    }

    public final T waitFor(@NotNull TemporalAmount duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Instant endOfWait = Instant.now().plus(duration);
        Object currentValue = null;
        do {
            if (((Boolean)this.condition.invoke(currentValue = this.provider.invoke())).booleanValue()) {
                return (T)currentValue;
            }
            Thread.sleep(this.backoffMillis);
            currentValue = this.provider.invoke();
            if (!((Boolean)this.condition.invoke(currentValue)).booleanValue()) continue;
            return (T)currentValue;
        } while (endOfWait.isAfter(Instant.now()));
        throw new InterruptedException("Wait limit reached");
    }

    public final T waitForSeconds(int duration) {
        Duration duration2 = Duration.ofSeconds(duration);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        return this.waitFor(duration2);
    }

    private final Function0<T> component1() {
        return this.provider;
    }

    private final Function1<T, Boolean> component2() {
        return this.condition;
    }

    private final long component3() {
        return this.backoffMillis;
    }

    @NotNull
    public final BusyWait<T> copy(@NotNull Function0<? extends T> provider, @NotNull Function1<? super T, Boolean> condition, long backoffMillis) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        return new BusyWait<T>(provider, condition, backoffMillis);
    }

    public static /* synthetic */ BusyWait copy$default(BusyWait busyWait, Function0 function0, Function1 function1, long l, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = busyWait.provider;
        }
        if ((n & 2) != 0) {
            function1 = busyWait.condition;
        }
        if ((n & 4) != 0) {
            l = busyWait.backoffMillis;
        }
        return busyWait.copy(function0, function1, l);
    }

    @NotNull
    public String toString() {
        return "BusyWait(provider=" + this.provider + ", condition=" + this.condition + ", backoffMillis=" + this.backoffMillis + ")";
    }

    public int hashCode() {
        int result = this.provider.hashCode();
        result = result * 31 + this.condition.hashCode();
        result = result * 31 + Long.hashCode(this.backoffMillis);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BusyWait)) {
            return false;
        }
        BusyWait busyWait = (BusyWait)other;
        if (!Intrinsics.areEqual(this.provider, busyWait.provider)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.condition, busyWait.condition)) {
            return false;
        }
        return this.backoffMillis == busyWait.backoffMillis;
    }

    @JvmStatic
    public static final <T> T toBeNonNull(int timeoutInSeconds, @NotNull Function0<? extends T> provider) {
        return Companion.toBeNonNull(timeoutInSeconds, provider);
    }

    @JvmStatic
    public static final void toBeTrue(int timeoutInSeconds, @NotNull Function0<Boolean> provider) {
        Companion.toBeTrue(timeoutInSeconds, provider);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0001\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0007\u00a8\u0006\r"}, d2={"Lde/lise/fluxflow/test/scheduling/util/BusyWait$Companion;", "", "()V", "toBeNonNull", "T", "timeoutInSeconds", "", "provider", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toBeTrue", "", "", "test-scheduling"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <T> T toBeNonNull(int timeoutInSeconds, @NotNull Function0<? extends T> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Object t = new BusyWait(provider, toBeNonNull.1.INSTANCE, 0L, 4, null).waitForSeconds(timeoutInSeconds);
            Intrinsics.checkNotNull(t);
            return t;
        }

        @JvmStatic
        public final void toBeTrue(int timeoutInSeconds, @NotNull Function0<Boolean> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            new BusyWait(provider, toBeTrue.1.INSTANCE, 0L, 4, null).waitForSeconds(timeoutInSeconds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

