/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.test.scheduling;

import de.lise.fluxflow.api.job.CancellationKey;
import de.lise.fluxflow.api.workflow.WorkflowIdentifier;
import de.lise.fluxflow.scheduling.SchedulingCallback;
import de.lise.fluxflow.scheduling.SchedulingReference;
import de.lise.fluxflow.scheduling.SchedulingService;
import de.lise.fluxflow.test.scheduling.TestCancellationKey;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/lise/fluxflow/test/scheduling/TestSchedulingService;", "Lde/lise/fluxflow/scheduling/SchedulingService;", "callbacks", "", "Lde/lise/fluxflow/scheduling/SchedulingCallback;", "([Lde/lise/fluxflow/scheduling/SchedulingCallback;)V", "", "(Ljava/util/Set;)V", "concurrentCancellationMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/lise/fluxflow/test/scheduling/TestCancellationKey;", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "cancel", "", "workflowIdentifier", "Lde/lise/fluxflow/api/workflow/WorkflowIdentifier;", "cancellationKey", "Lde/lise/fluxflow/api/job/CancellationKey;", "notify", "schedulingReference", "Lde/lise/fluxflow/scheduling/SchedulingReference;", "registerListener", "callback", "schedule", "pointInTime", "Ljava/time/Instant;", "Companion", "test-scheduling"})
@SourceDebugExtension(value={"SMAP\nTestSchedulingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestSchedulingService.kt\nde/lise/fluxflow/test/scheduling/TestSchedulingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1855#2,2:96\n*S KotlinDebug\n*F\n+ 1 TestSchedulingService.kt\nde/lise/fluxflow/test/scheduling/TestSchedulingService\n*L\n78#1:96,2\n*E\n"})
public final class TestSchedulingService
implements SchedulingService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SchedulingCallback> callbacks;
    private final ExecutorService executorService;
    @NotNull
    private final ConcurrentHashMap<TestCancellationKey, Boolean> concurrentCancellationMap;
    @NotNull
    private static final Logger Logger;

    public TestSchedulingService(@NotNull Set<SchedulingCallback> callbacks) {
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        this.callbacks = callbacks;
        this.executorService = Executors.newCachedThreadPool();
        this.concurrentCancellationMap = new ConcurrentHashMap();
    }

    public TestSchedulingService(SchedulingCallback ... callbacks) {
        Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
        this(ArraysKt.toMutableSet((Object[])callbacks));
    }

    public void schedule(@NotNull Instant pointInTime, @NotNull SchedulingReference schedulingReference) {
        Intrinsics.checkNotNullParameter((Object)pointInTime, (String)"pointInTime");
        Intrinsics.checkNotNullParameter((Object)schedulingReference, (String)"schedulingReference");
        long remainingTimeInMillis = pointInTime.toEpochMilli() - Instant.now().toEpochMilli();
        if (remainingTimeInMillis <= 0L) {
            this.notify(schedulingReference);
            return;
        }
        CancellationKey cancellationKey = schedulingReference.getCancellationKey();
        if (cancellationKey != null) {
            CancellationKey it = cancellationKey;
            boolean bl = false;
            this.concurrentCancellationMap.put(new TestCancellationKey(schedulingReference.getWorkflowIdentifier(), it), false);
        }
        this.executorService.submit(() -> TestSchedulingService.schedule$lambda$2(remainingTimeInMillis, schedulingReference, this));
    }

    public void cancel(@NotNull WorkflowIdentifier workflowIdentifier, @NotNull CancellationKey cancellationKey) {
        Intrinsics.checkNotNullParameter((Object)workflowIdentifier, (String)"workflowIdentifier");
        Intrinsics.checkNotNullParameter((Object)cancellationKey, (String)"cancellationKey");
        ((Map)this.concurrentCancellationMap).put(new TestCancellationKey(workflowIdentifier, cancellationKey), true);
    }

    public void registerListener(@NotNull SchedulingCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    private final void notify(SchedulingReference schedulingReference) {
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SchedulingCallback it = (SchedulingCallback)element$iv;
            boolean bl = false;
            try {
                it.onScheduled(schedulingReference);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{it, schedulingReference, e};
                Logger.error("An error occurred invoking callback ({}) for scheduled event {}.", objectArray);
            }
        }
    }

    private static final void schedule$lambda$2(long $remainingTimeInMillis, SchedulingReference $schedulingReference, TestSchedulingService this$0) {
        boolean isCanceled;
        Intrinsics.checkNotNullParameter((Object)$schedulingReference, (String)"$schedulingReference");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread.sleep($remainingTimeInMillis);
        CancellationKey cancellationKey = $schedulingReference.getCancellationKey();
        if (cancellationKey != null) {
            CancellationKey it = cancellationKey;
            boolean bl = false;
            TestCancellationKey key = new TestCancellationKey($schedulingReference.getWorkflowIdentifier(), it);
            Boolean bl2 = this$0.concurrentCancellationMap.getOrDefault(key, false);
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getOrDefault(...)");
            boolean result = bl2;
            this$0.concurrentCancellationMap.remove(key);
            v2 = result;
        } else {
            v2 = isCanceled = false;
        }
        if (!isCanceled) {
            this$0.notify($schedulingReference);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(TestSchedulingService.class);
        Intrinsics.checkNotNull((Object)logger);
        Logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/lise/fluxflow/test/scheduling/TestSchedulingService$Companion;", "", "()V", "Logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "test-scheduling"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return Logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

