/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.springboot.ioc;

import de.lise.fluxflow.api.ioc.IocProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0002\u00a2\u0006\u0002\u0010\nJ)\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/lise/fluxflow/springboot/ioc/SpringIocProvider;", "Lde/lise/fluxflow/api/ioc/IocProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "provide", "TDependency", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "Lkotlin/reflect/KType;", "Companion", "springboot"})
public final class SpringIocProvider
implements IocProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private static final Logger Logger;

    public SpringIocProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @Nullable
    public <TDependency> TDependency provide(@NotNull KClass<? extends TDependency> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.provide(JvmClassMappingKt.getJavaClass(type));
    }

    @Nullable
    public Object provide(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        KClass kClass = kClassifier instanceof KClass ? (KClass)kClassifier : null;
        Class javaClass = kClass != null ? JvmClassMappingKt.getJavaClass((KClass)kClass) : null;
        Intrinsics.checkNotNull((Object)javaClass, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        return this.provide(javaClass);
    }

    private final <TDependency> TDependency provide(Class<TDependency> clazz) {
        Object object;
        try {
            object = this.applicationContext.getBean(clazz);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            Logger.debug("Could not find a bean of type '{}' in the application context.", (Object)clazz.getSimpleName(), (Object)e);
            object = null;
        }
        return (TDependency)object;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SpringIocProvider.class);
        Intrinsics.checkNotNull((Object)logger);
        Logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/lise/fluxflow/springboot/ioc/SpringIocProvider$Companion;", "", "()V", "Logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "springboot"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return Logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

