/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.springboot.configuration;

import de.lise.fluxflow.api.bootstrapping.BootstrapAction;
import de.lise.fluxflow.api.event.EventService;
import de.lise.fluxflow.api.event.FlowListener;
import de.lise.fluxflow.api.ioc.IocProvider;
import de.lise.fluxflow.api.job.JobService;
import de.lise.fluxflow.api.state.ChangeDetector;
import de.lise.fluxflow.api.step.StepService;
import de.lise.fluxflow.api.workflow.WorkflowQueryService;
import de.lise.fluxflow.api.workflow.WorkflowRemovalService;
import de.lise.fluxflow.api.workflow.WorkflowService;
import de.lise.fluxflow.api.workflow.WorkflowStarterService;
import de.lise.fluxflow.api.workflow.WorkflowUpdateService;
import de.lise.fluxflow.engine.bootstrapping.BootstrappingService;
import de.lise.fluxflow.engine.continuation.ContinuationService;
import de.lise.fluxflow.engine.continuation.history.ContinuationHistoryServiceImpl;
import de.lise.fluxflow.engine.event.EventServiceImpl;
import de.lise.fluxflow.engine.job.JobActivationService;
import de.lise.fluxflow.engine.job.JobSchedulingCallback;
import de.lise.fluxflow.engine.job.JobServiceImpl;
import de.lise.fluxflow.engine.reflection.ClassLoaderProvider;
import de.lise.fluxflow.engine.state.DefaultChangeDetector;
import de.lise.fluxflow.engine.step.StepActivationService;
import de.lise.fluxflow.engine.step.StepActivationServiceImpl;
import de.lise.fluxflow.engine.step.StepServiceImpl;
import de.lise.fluxflow.engine.step.StepTypeResolver;
import de.lise.fluxflow.engine.step.StepTypeResolverImpl;
import de.lise.fluxflow.engine.step.action.ActionServiceImpl;
import de.lise.fluxflow.engine.step.data.StepDataServiceImpl;
import de.lise.fluxflow.engine.step.validation.ValidationService;
import de.lise.fluxflow.engine.workflow.WorkflowActivationService;
import de.lise.fluxflow.engine.workflow.WorkflowActivationServiceImpl;
import de.lise.fluxflow.engine.workflow.WorkflowQueryServiceImpl;
import de.lise.fluxflow.engine.workflow.WorkflowRemovalServiceImpl;
import de.lise.fluxflow.engine.workflow.WorkflowServiceImpl;
import de.lise.fluxflow.engine.workflow.WorkflowStarterServiceImpl;
import de.lise.fluxflow.engine.workflow.WorkflowUpdateServiceImpl;
import de.lise.fluxflow.persistence.continuation.history.ContinuationRecordPersistence;
import de.lise.fluxflow.persistence.job.JobPersistence;
import de.lise.fluxflow.persistence.step.StepData;
import de.lise.fluxflow.persistence.step.StepPersistence;
import de.lise.fluxflow.persistence.workflow.WorkflowData;
import de.lise.fluxflow.persistence.workflow.WorkflowPersistence;
import de.lise.fluxflow.reflection.activation.parameter.IocParameterResolver;
import de.lise.fluxflow.reflection.activation.parameter.ParameterResolver;
import de.lise.fluxflow.reflection.activation.parameter.PriorityParameterResolver;
import de.lise.fluxflow.scheduling.SchedulingCallback;
import de.lise.fluxflow.scheduling.SchedulingService;
import de.lise.fluxflow.springboot.activation.StepKindMapBuilder;
import de.lise.fluxflow.springboot.activation.parameter.SpringValueExpressionParameterResolver;
import de.lise.fluxflow.springboot.bootstrapping.SpringBootstrapper;
import de.lise.fluxflow.springboot.configuration.ChangeDetectionConfiguration;
import de.lise.fluxflow.springboot.expression.SpringSelectorExpressionParser;
import de.lise.fluxflow.springboot.ioc.SpringIocProvider;
import de.lise.fluxflow.stereotyped.continuation.ContinuationBuilder;
import de.lise.fluxflow.stereotyped.job.JobDefinitionBuilder;
import de.lise.fluxflow.stereotyped.job.parameter.ParameterDefinitionBuilder;
import de.lise.fluxflow.stereotyped.metadata.MetadataBuilder;
import de.lise.fluxflow.stereotyped.step.StepDefinitionBuilder;
import de.lise.fluxflow.stereotyped.step.action.ActionDefinitionBuilder;
import de.lise.fluxflow.stereotyped.step.action.ActionFunctionResolver;
import de.lise.fluxflow.stereotyped.step.action.ActionFunctionResolverImpl;
import de.lise.fluxflow.stereotyped.step.automation.AutomationDefinitionBuilder;
import de.lise.fluxflow.stereotyped.step.data.DataDefinitionBuilder;
import de.lise.fluxflow.stereotyped.step.data.DataListenerDefinitionBuilder;
import de.lise.fluxflow.stereotyped.step.data.validation.ValidationBuilder;
import de.lise.fluxflow.stereotyped.unwrapping.UnwrapService;
import de.lise.fluxflow.stereotyped.unwrapping.UnwrapServiceImpl;
import de.lise.fluxflow.stereotyped.workflow.ModelListenerDefinitionBuilder;
import de.lise.fluxflow.stereotyped.workflow.SelectorExpressionParser;
import de.lise.fluxflow.validation.jakarta.JakartaDataValidationBuilder;
import de.lise.fluxflow.validation.noop.NoOpDataValidationBuilder;
import jakarta.validation.Validator;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@ComponentScan(basePackages={"de.lise.fluxflow.springboot.autoconfigure"})
@Import(value={ChangeDetectionConfiguration.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J\b\u0010\u001c\u001a\u00020\u001dH\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00102\u001a\u000203H\u0017J \u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u00106\u001a\u0002072\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0016\u0010\u0013\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001aH\u0017J\u0010\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020?H\u0017J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020!H\u0017J\u0010\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020CH\u0017J \u0010D\u001a\u00020E2\u0006\u0010>\u001a\u00020?2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J(\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017J2\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010,\u001a\u00020P2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017J \u0010,\u001a\u00020P2\u0006\u0010D\u001a\u00020E2\u0006\u0010Q\u001a\u00020R2\u0006\u0010L\u001a\u00020MH\u0017J\u0018\u0010S\u001a\u00020T2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010U\u001a\u00020VH\u0017J\b\u0010W\u001a\u000209H\u0017J\b\u0010H\u001a\u00020IH\u0017J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0017J\b\u0010U\u001a\u00020VH\u0017J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010[\u001a\u00020\f2\u0006\u0010\\\u001a\u00020]H\u0017J \u0010^\u001a\u00020+2\u0006\u0010>\u001a\u00020?2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0017J2\u0010c\u001a\u00020d2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010e\u001a\u00020fH\u0017J(\u0010_\u001a\u00020`2\u0006\u0010g\u001a\u00020\u00062\u0006\u0010h\u001a\u0002052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\b\u0010l\u001a\u00020\nH\u0017J.\u0010&\u001a\u00020)2\u0006\u0010m\u001a\u00020n2\u0006\u0010^\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010o\u001a\b\u0012\u0004\u0012\u00020q0pH\u0017J\u0018\u0010a\u001a\u00020b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020jH\u0017J\b\u0010r\u001a\u00020sH\u0017J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010t\u001a\u00020fH\u0017J\u0010\u0010u\u001a\u00020v2\u0006\u0010S\u001a\u00020TH\u0017J\u0018\u0010N\u001a\u0002012\u0006\u0010m\u001a\u00020w2\u0006\u0010*\u001a\u00020vH\u0017J0\u00102\u001a\u0002032\u0006\u0010m\u001a\u00020w2\u0006\u0010*\u001a\u00020v2\u0006\u0010&\u001a\u00020)2\u0006\u0010,\u001a\u00020P2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J(\u00100\u001a\u00020x2\u0006\u0010.\u001a\u00020/2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00102\u001a\u00020yH\u0017J(\u0010.\u001a\u00020/2\u0006\u0010m\u001a\u00020w2\u0006\u00100\u001a\u0002012\u0006\u0010u\u001a\u00020v2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010m\u001a\u00020w2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020z0p2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010*\u001a\u00020vH\u0017R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lde/lise/fluxflow/springboot/configuration/BasicConfiguration;", "", "()V", "continuationService", "Lde/lise/fluxflow/engine/continuation/ContinuationService;", "actionBuilder", "Lde/lise/fluxflow/stereotyped/step/action/ActionDefinitionBuilder;", "continuationBuilder", "Lde/lise/fluxflow/stereotyped/continuation/ContinuationBuilder;", "metadataBuilder", "Lde/lise/fluxflow/stereotyped/metadata/MetadataBuilder;", "parameterResolver", "Lde/lise/fluxflow/reflection/activation/parameter/ParameterResolver;", "actionService", "Lde/lise/fluxflow/engine/step/action/ActionServiceImpl;", "workflowUpdateService", "Lde/lise/fluxflow/api/workflow/WorkflowUpdateService;", "validationService", "Lde/lise/fluxflow/engine/step/validation/ValidationService;", "eventService", "Lde/lise/fluxflow/api/event/EventService;", "automationDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/step/automation/AutomationDefinitionBuilder;", "bootstrappingService", "Lde/lise/fluxflow/engine/bootstrapping/BootstrappingService;", "actions", "", "Lde/lise/fluxflow/api/bootstrapping/BootstrapAction;", "clock", "Ljava/time/Clock;", "classLoaderProvider", "Lde/lise/fluxflow/engine/reflection/ClassLoaderProvider;", "app", "Lorg/springframework/context/ApplicationContext;", "continuationHistoryService", "Lde/lise/fluxflow/engine/continuation/history/ContinuationHistoryServiceImpl;", "continuationRecordPersistence", "Lde/lise/fluxflow/persistence/continuation/history/ContinuationRecordPersistence;", "stepService", "Lde/lise/fluxflow/api/step/StepService;", "stepServiceImpl", "Lde/lise/fluxflow/engine/step/StepServiceImpl;", "activationService", "Lde/lise/fluxflow/engine/step/StepActivationService;", "jobService", "Lde/lise/fluxflow/api/job/JobService;", "workflowStarterService", "Lde/lise/fluxflow/api/workflow/WorkflowStarterService;", "workflowService", "Lde/lise/fluxflow/engine/workflow/WorkflowQueryServiceImpl;", "workflowRemovalService", "Lde/lise/fluxflow/engine/workflow/WorkflowRemovalServiceImpl;", "dataBuilder", "Lde/lise/fluxflow/stereotyped/step/data/DataDefinitionBuilder;", "dataListenerDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/step/data/DataListenerDefinitionBuilder;", "validationBuilder", "Lde/lise/fluxflow/stereotyped/step/data/validation/ValidationBuilder;", "Lde/lise/fluxflow/engine/event/EventServiceImpl;", "listeners", "Lde/lise/fluxflow/api/event/FlowListener;", "iocParameterResolver", "iocProvider", "Lde/lise/fluxflow/api/ioc/IocProvider;", "applicationContext", "jakartaValidation", "validator", "Ljakarta/validation/Validator;", "jobActivationService", "Lde/lise/fluxflow/engine/job/JobActivationService;", "jobDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/job/JobDefinitionBuilder;", "parameterDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/job/parameter/ParameterDefinitionBuilder;", "jobSchedulingCallback", "Lde/lise/fluxflow/scheduling/SchedulingCallback;", "schedulingService", "Lde/lise/fluxflow/scheduling/SchedulingService;", "workflowQueryService", "Lde/lise/fluxflow/api/workflow/WorkflowQueryService;", "Lde/lise/fluxflow/engine/job/JobServiceImpl;", "jobPersistence", "Lde/lise/fluxflow/persistence/job/JobPersistence;", "modelListenerDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/workflow/ModelListenerDefinitionBuilder;", "selectorExpressionParser", "Lde/lise/fluxflow/stereotyped/workflow/SelectorExpressionParser;", "noOpValidation", "resolvers", "springBootstrapper", "Lde/lise/fluxflow/springboot/bootstrapping/SpringBootstrapper;", "springValueParameterResolver", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "stepActivationService", "stepDefinitionBuilder", "Lde/lise/fluxflow/stereotyped/step/StepDefinitionBuilder;", "stepTypeResolver", "Lde/lise/fluxflow/engine/step/StepTypeResolver;", "stepDataService", "Lde/lise/fluxflow/engine/step/data/StepDataServiceImpl;", "allowInactiveModification", "", "actionDefinitionBuilder", "dataDefinitionBuilder", "stepKindMapBuilder", "Lde/lise/fluxflow/springboot/activation/StepKindMapBuilder;", "context", "stepMetadataBuilder", "persistence", "Lde/lise/fluxflow/persistence/step/StepPersistence;", "changeDetector", "Lde/lise/fluxflow/api/state/ChangeDetector;", "Lde/lise/fluxflow/persistence/step/StepData;", "unwrapService", "Lde/lise/fluxflow/stereotyped/unwrapping/UnwrapService;", "validateBeforeActionExecution", "workflowActivationService", "Lde/lise/fluxflow/engine/workflow/WorkflowActivationService;", "Lde/lise/fluxflow/persistence/workflow/WorkflowPersistence;", "Lde/lise/fluxflow/api/workflow/WorkflowService;", "Lde/lise/fluxflow/api/workflow/WorkflowRemovalService;", "Lde/lise/fluxflow/persistence/workflow/WorkflowData;", "springboot"})
@SourceDebugExtension(value={"SMAP\nBasicConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicConfiguration.kt\nde/lise/fluxflow/springboot/configuration/BasicConfiguration\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,539:1\n37#2,2:540\n*S KotlinDebug\n*F\n+ 1 BasicConfiguration.kt\nde/lise/fluxflow/springboot/configuration/BasicConfiguration\n*L\n116#1:540,2\n*E\n"})
public class BasicConfiguration {
    @Lazy
    @Autowired
    @Nullable
    private ContinuationService continuationService;

    @Bean
    @NotNull
    public IocProvider iocProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new SpringIocProvider(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={Clock.class})
    @NotNull
    public Clock clock() {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
        return clock;
    }

    @Bean
    @NotNull
    public ParameterResolver springValueParameterResolver(@NotNull ConfigurableBeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        return new SpringValueExpressionParameterResolver(beanFactory);
    }

    @Bean
    @NotNull
    public ParameterResolver iocParameterResolver(@NotNull IocProvider iocProvider) {
        Intrinsics.checkNotNullParameter((Object)iocProvider, (String)"iocProvider");
        return (ParameterResolver)new IocParameterResolver(iocProvider);
    }

    @Bean
    @Primary
    @NotNull
    public ParameterResolver parameterResolver(@NotNull List<? extends ParameterResolver> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        if (resolvers.size() == 1) {
            return (ParameterResolver)CollectionsKt.first(resolvers);
        }
        Collection $this$toTypedArray$iv = resolvers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ParameterResolver[] parameterResolverArray = thisCollection$iv.toArray(new ParameterResolver[0]);
        return (ParameterResolver)new PriorityParameterResolver(Arrays.copyOf(parameterResolverArray, parameterResolverArray.length));
    }

    @Bean
    @NotNull
    public SelectorExpressionParser selectorExpressionParser() {
        return new SpringSelectorExpressionParser(new SpelExpressionParser());
    }

    @Bean
    @NotNull
    public ModelListenerDefinitionBuilder modelListenerDefinitionBuilder(@NotNull ParameterResolver parameterResolver, @NotNull SelectorExpressionParser selectorExpressionParser) {
        Intrinsics.checkNotNullParameter((Object)parameterResolver, (String)"parameterResolver");
        Intrinsics.checkNotNullParameter((Object)selectorExpressionParser, (String)"selectorExpressionParser");
        return new ModelListenerDefinitionBuilder(parameterResolver, (ChangeDetector)new DefaultChangeDetector(), selectorExpressionParser, null, 8, null);
    }

    @Bean
    @NotNull
    public WorkflowActivationService workflowActivationService(@NotNull ModelListenerDefinitionBuilder modelListenerDefinitionBuilder) {
        Intrinsics.checkNotNullParameter((Object)modelListenerDefinitionBuilder, (String)"modelListenerDefinitionBuilder");
        return (WorkflowActivationService)new WorkflowActivationServiceImpl(modelListenerDefinitionBuilder);
    }

    @Bean
    @Primary
    @NotNull
    public WorkflowUpdateService workflowUpdateService(@NotNull WorkflowPersistence persistence, @NotNull ChangeDetector<? super WorkflowData> changeDetector, @NotNull EventService eventService, @NotNull WorkflowActivationService activationService) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        Intrinsics.checkNotNullParameter(changeDetector, (String)"changeDetector");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)activationService, (String)"activationService");
        return (WorkflowUpdateService)new WorkflowUpdateServiceImpl(persistence, changeDetector, eventService, activationService);
    }

    @Bean
    @Primary
    @NotNull
    public WorkflowQueryServiceImpl workflowQueryService(@NotNull WorkflowPersistence persistence, @NotNull WorkflowActivationService activationService) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        Intrinsics.checkNotNullParameter((Object)activationService, (String)"activationService");
        return new WorkflowQueryServiceImpl(persistence, activationService);
    }

    @Bean
    @Primary
    @NotNull
    public WorkflowRemovalServiceImpl workflowRemovalService(@NotNull WorkflowPersistence persistence, @NotNull WorkflowActivationService activationService, @NotNull StepServiceImpl stepService, @NotNull JobServiceImpl jobService, @NotNull EventService eventService) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        Intrinsics.checkNotNullParameter((Object)activationService, (String)"activationService");
        Intrinsics.checkNotNullParameter((Object)stepService, (String)"stepService");
        Intrinsics.checkNotNullParameter((Object)jobService, (String)"jobService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        return new WorkflowRemovalServiceImpl(persistence, activationService, stepService, jobService, eventService);
    }

    @Bean
    @Primary
    @NotNull
    public WorkflowStarterService workflowStarterService(@NotNull WorkflowPersistence persistence, @NotNull WorkflowQueryServiceImpl workflowService, @NotNull WorkflowActivationService workflowActivationService, @NotNull EventService eventService) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        Intrinsics.checkNotNullParameter((Object)workflowService, (String)"workflowService");
        Intrinsics.checkNotNullParameter((Object)workflowActivationService, (String)"workflowActivationService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        ContinuationService continuationService = this.continuationService;
        Intrinsics.checkNotNull((Object)continuationService);
        return (WorkflowStarterService)new WorkflowStarterServiceImpl(persistence, workflowActivationService, continuationService, eventService);
    }

    @Bean
    @NotNull
    public WorkflowService workflowService(@NotNull WorkflowStarterService workflowStarterService, @NotNull WorkflowQueryService workflowQueryService, @NotNull WorkflowUpdateService workflowUpdateService, @NotNull WorkflowRemovalService workflowRemovalService) {
        Intrinsics.checkNotNullParameter((Object)workflowStarterService, (String)"workflowStarterService");
        Intrinsics.checkNotNullParameter((Object)workflowQueryService, (String)"workflowQueryService");
        Intrinsics.checkNotNullParameter((Object)workflowUpdateService, (String)"workflowUpdateService");
        Intrinsics.checkNotNullParameter((Object)workflowRemovalService, (String)"workflowRemovalService");
        return (WorkflowService)new WorkflowServiceImpl(workflowStarterService, workflowQueryService, workflowUpdateService, workflowRemovalService);
    }

    @Bean
    @NotNull
    public ContinuationBuilder continuationBuilder() {
        return new ContinuationBuilder();
    }

    @Bean
    @NotNull
    public ActionDefinitionBuilder actionBuilder(@NotNull ContinuationBuilder continuationBuilder, @NotNull MetadataBuilder metadataBuilder, @NotNull ParameterResolver parameterResolver) {
        Intrinsics.checkNotNullParameter((Object)continuationBuilder, (String)"continuationBuilder");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)parameterResolver, (String)"parameterResolver");
        return new ActionDefinitionBuilder(continuationBuilder, metadataBuilder, (ActionFunctionResolver)new ActionFunctionResolverImpl(parameterResolver));
    }

    @Bean
    @NotNull
    public DataListenerDefinitionBuilder dataListenerDefinitionBuilder(@NotNull ContinuationBuilder continuationBuilder, @NotNull ParameterResolver parameterResolver) {
        Intrinsics.checkNotNullParameter((Object)continuationBuilder, (String)"continuationBuilder");
        Intrinsics.checkNotNullParameter((Object)parameterResolver, (String)"parameterResolver");
        return new DataListenerDefinitionBuilder(continuationBuilder, parameterResolver);
    }

    @Bean
    @NotNull
    public DataDefinitionBuilder dataBuilder(@NotNull DataListenerDefinitionBuilder dataListenerDefinitionBuilder, @NotNull ValidationBuilder validationBuilder, @NotNull MetadataBuilder metadataBuilder) {
        Intrinsics.checkNotNullParameter((Object)dataListenerDefinitionBuilder, (String)"dataListenerDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)validationBuilder, (String)"validationBuilder");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        return new DataDefinitionBuilder(dataListenerDefinitionBuilder, validationBuilder, metadataBuilder);
    }

    @Bean
    @NotNull
    public AutomationDefinitionBuilder automationDefinitionBuilder(@NotNull ContinuationBuilder continuationBuilder, @NotNull ParameterResolver parameterResolver) {
        Intrinsics.checkNotNullParameter((Object)continuationBuilder, (String)"continuationBuilder");
        Intrinsics.checkNotNullParameter((Object)parameterResolver, (String)"parameterResolver");
        return new AutomationDefinitionBuilder(continuationBuilder, parameterResolver);
    }

    @Bean
    @NotNull
    public MetadataBuilder stepMetadataBuilder() {
        return new MetadataBuilder(null, null, null, 7, null);
    }

    @Bean
    @NotNull
    public StepDefinitionBuilder stepDefinitionBuilder(@NotNull ActionDefinitionBuilder actionDefinitionBuilder, @NotNull DataDefinitionBuilder dataDefinitionBuilder, @NotNull MetadataBuilder metadataBuilder, @NotNull AutomationDefinitionBuilder automationDefinitionBuilder) {
        Intrinsics.checkNotNullParameter((Object)actionDefinitionBuilder, (String)"actionDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)dataDefinitionBuilder, (String)"dataDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        Intrinsics.checkNotNullParameter((Object)automationDefinitionBuilder, (String)"automationDefinitionBuilder");
        return new StepDefinitionBuilder(actionDefinitionBuilder, dataDefinitionBuilder, metadataBuilder, automationDefinitionBuilder, null, 16, null);
    }

    @Bean
    @NotNull
    public ParameterDefinitionBuilder parameterDefinitionBuilder() {
        return new ParameterDefinitionBuilder();
    }

    @Bean
    @NotNull
    public JobDefinitionBuilder jobDefinitionBuilder(@NotNull ParameterDefinitionBuilder parameterDefinitionBuilder, @NotNull ContinuationBuilder continuationBuilder, @NotNull ParameterResolver parameterResolver, @NotNull MetadataBuilder metadataBuilder) {
        Intrinsics.checkNotNullParameter((Object)parameterDefinitionBuilder, (String)"parameterDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)continuationBuilder, (String)"continuationBuilder");
        Intrinsics.checkNotNullParameter((Object)parameterResolver, (String)"parameterResolver");
        Intrinsics.checkNotNullParameter((Object)metadataBuilder, (String)"metadataBuilder");
        return new JobDefinitionBuilder(parameterDefinitionBuilder, continuationBuilder, parameterResolver, metadataBuilder, (Map)new LinkedHashMap());
    }

    @Bean
    @NotNull
    public UnwrapService unwrapService() {
        return (UnwrapService)new UnwrapServiceImpl();
    }

    @Bean
    @NotNull
    public ClassLoaderProvider classLoaderProvider(@NotNull ApplicationContext app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return () -> BasicConfiguration.classLoaderProvider$lambda$0(app);
    }

    @Bean
    @NotNull
    public JobActivationService jobActivationService(@NotNull IocProvider iocProvider, @NotNull JobDefinitionBuilder jobDefinitionBuilder, @NotNull ClassLoaderProvider classLoaderProvider) {
        Intrinsics.checkNotNullParameter((Object)iocProvider, (String)"iocProvider");
        Intrinsics.checkNotNullParameter((Object)jobDefinitionBuilder, (String)"jobDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)classLoaderProvider, (String)"classLoaderProvider");
        return new JobActivationService(iocProvider, jobDefinitionBuilder, classLoaderProvider);
    }

    @Bean
    @NotNull
    public StepActivationService stepActivationService(@NotNull IocProvider iocProvider, @NotNull StepDefinitionBuilder stepDefinitionBuilder, @NotNull StepTypeResolver stepTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)iocProvider, (String)"iocProvider");
        Intrinsics.checkNotNullParameter((Object)stepDefinitionBuilder, (String)"stepDefinitionBuilder");
        Intrinsics.checkNotNullParameter((Object)stepTypeResolver, (String)"stepTypeResolver");
        return (StepActivationService)new StepActivationServiceImpl(iocProvider, stepDefinitionBuilder, stepTypeResolver);
    }

    @Bean
    @NotNull
    public StepKindMapBuilder stepKindMapBuilder(@NotNull ApplicationContext context, @NotNull ClassLoaderProvider classLoaderProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)classLoaderProvider, (String)"classLoaderProvider");
        return new StepKindMapBuilder(context, classLoaderProvider.provide());
    }

    @Bean
    @NotNull
    public StepTypeResolver stepTypeResolver(@NotNull ClassLoaderProvider classLoaderProvider, @NotNull StepKindMapBuilder stepKindMapBuilder) {
        Intrinsics.checkNotNullParameter((Object)classLoaderProvider, (String)"classLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)stepKindMapBuilder, (String)"stepKindMapBuilder");
        return (StepTypeResolver)new StepTypeResolverImpl(classLoaderProvider.provide(), stepKindMapBuilder.build());
    }

    @Bean
    @NotNull
    public ValidationService validationService(@Value(value="${fluxflow.action.validate-before:true}") boolean validateBeforeActionExecution) {
        return new ValidationService(validateBeforeActionExecution);
    }

    @Bean
    @NotNull
    public StepServiceImpl stepService(@NotNull StepPersistence persistence, @NotNull StepActivationService stepActivationService, @NotNull EventService eventService, @NotNull ChangeDetector<? super StepData> changeDetector) {
        Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
        Intrinsics.checkNotNullParameter((Object)stepActivationService, (String)"stepActivationService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter(changeDetector, (String)"changeDetector");
        ContinuationService continuationService = this.continuationService;
        Intrinsics.checkNotNull((Object)continuationService);
        return new StepServiceImpl(persistence, stepActivationService, eventService, continuationService, changeDetector);
    }

    @Bean
    @NotNull
    public ContinuationService continuationService(@NotNull StepServiceImpl stepServiceImpl, @NotNull StepActivationService activationService, @NotNull JobService jobService, @NotNull ContinuationHistoryServiceImpl continuationHistoryService, @NotNull WorkflowStarterService workflowStarterService, @NotNull WorkflowQueryServiceImpl workflowService, @NotNull WorkflowUpdateService workflowUpdateService, @NotNull WorkflowRemovalServiceImpl workflowRemovalService) {
        Intrinsics.checkNotNullParameter((Object)stepServiceImpl, (String)"stepServiceImpl");
        Intrinsics.checkNotNullParameter((Object)activationService, (String)"activationService");
        Intrinsics.checkNotNullParameter((Object)jobService, (String)"jobService");
        Intrinsics.checkNotNullParameter((Object)continuationHistoryService, (String)"continuationHistoryService");
        Intrinsics.checkNotNullParameter((Object)workflowStarterService, (String)"workflowStarterService");
        Intrinsics.checkNotNullParameter((Object)workflowService, (String)"workflowService");
        Intrinsics.checkNotNullParameter((Object)workflowUpdateService, (String)"workflowUpdateService");
        Intrinsics.checkNotNullParameter((Object)workflowRemovalService, (String)"workflowRemovalService");
        return new ContinuationService(stepServiceImpl, activationService, jobService, continuationHistoryService, workflowStarterService, workflowService, workflowUpdateService, workflowRemovalService);
    }

    @Bean
    @NotNull
    public StepDataServiceImpl stepDataService(@NotNull StepServiceImpl stepServiceImpl, @NotNull WorkflowUpdateService workflowUpdateService, @NotNull EventService eventService, @NotNull ContinuationService continuationService, @Value(value="${fluxflow.data.allow-inactive-modification:true}") boolean allowInactiveModification) {
        Intrinsics.checkNotNullParameter((Object)stepServiceImpl, (String)"stepServiceImpl");
        Intrinsics.checkNotNullParameter((Object)workflowUpdateService, (String)"workflowUpdateService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)continuationService, (String)"continuationService");
        return new StepDataServiceImpl(stepServiceImpl, workflowUpdateService, eventService, allowInactiveModification, continuationService);
    }

    @Bean
    @NotNull
    public ActionServiceImpl actionService(@NotNull WorkflowUpdateService workflowUpdateService, @NotNull ContinuationService continuationService, @NotNull ValidationService validationService, @NotNull EventService eventService) {
        Intrinsics.checkNotNullParameter((Object)workflowUpdateService, (String)"workflowUpdateService");
        Intrinsics.checkNotNullParameter((Object)continuationService, (String)"continuationService");
        Intrinsics.checkNotNullParameter((Object)validationService, (String)"validationService");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        return new ActionServiceImpl(workflowUpdateService, continuationService, validationService, eventService);
    }

    @Bean
    @NotNull
    public JobServiceImpl jobService(@NotNull JobActivationService jobActivationService, @NotNull JobPersistence jobPersistence, @NotNull SchedulingService schedulingService) {
        Intrinsics.checkNotNullParameter((Object)jobActivationService, (String)"jobActivationService");
        Intrinsics.checkNotNullParameter((Object)jobPersistence, (String)"jobPersistence");
        Intrinsics.checkNotNullParameter((Object)schedulingService, (String)"schedulingService");
        return new JobServiceImpl(jobActivationService, jobPersistence, schedulingService);
    }

    @Bean
    @Nullable
    public SchedulingCallback jobSchedulingCallback(@NotNull SchedulingService schedulingService, @NotNull WorkflowQueryService workflowQueryService, @NotNull WorkflowUpdateService workflowUpdateService, @NotNull JobServiceImpl jobService, @NotNull ContinuationService continuationService) {
        Intrinsics.checkNotNullParameter((Object)schedulingService, (String)"schedulingService");
        Intrinsics.checkNotNullParameter((Object)workflowQueryService, (String)"workflowQueryService");
        Intrinsics.checkNotNullParameter((Object)workflowUpdateService, (String)"workflowUpdateService");
        Intrinsics.checkNotNullParameter((Object)jobService, (String)"jobService");
        Intrinsics.checkNotNullParameter((Object)continuationService, (String)"continuationService");
        JobSchedulingCallback callback = new JobSchedulingCallback(workflowQueryService, workflowUpdateService, jobService, continuationService);
        schedulingService.registerListener((SchedulingCallback)callback);
        return (SchedulingCallback)callback;
    }

    @Bean
    @NotNull
    public EventServiceImpl eventService(@NotNull List<? extends FlowListener> listeners) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        return new EventServiceImpl(listeners);
    }

    @Bean
    @NotNull
    public ContinuationHistoryServiceImpl continuationHistoryService(@NotNull ContinuationRecordPersistence continuationRecordPersistence, @NotNull StepService stepService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)continuationRecordPersistence, (String)"continuationRecordPersistence");
        Intrinsics.checkNotNullParameter((Object)stepService, (String)"stepService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new ContinuationHistoryServiceImpl(continuationRecordPersistence, stepService, clock);
    }

    @Bean
    @ConditionalOnMissingBean(value={Validator.class})
    @NotNull
    public ValidationBuilder noOpValidation() {
        return (ValidationBuilder)new NoOpDataValidationBuilder();
    }

    @Bean
    @ConditionalOnBean(value={Validator.class})
    @NotNull
    public ValidationBuilder jakartaValidation(@NotNull Validator validator) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        return (ValidationBuilder)new JakartaDataValidationBuilder(validator);
    }

    @Bean
    @NotNull
    public BootstrappingService bootstrappingService(@NotNull List<? extends BootstrapAction> actions, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new BootstrappingService(actions, clock);
    }

    @Bean
    @NotNull
    public SpringBootstrapper springBootstrapper(@NotNull BootstrappingService bootstrappingService) {
        Intrinsics.checkNotNullParameter((Object)bootstrappingService, (String)"bootstrappingService");
        return new SpringBootstrapper(bootstrappingService);
    }

    private static final ClassLoader classLoaderProvider$lambda$0(ApplicationContext $app) {
        Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
        ClassLoader classLoader = $app.getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        return classLoader;
    }
}

