/*
 * Decompiled with CFR 0.152.
 */
package de.lise.fluxflow.springboot.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import de.lise.fluxflow.reflection.activation.parameter.FunctionParameter;
import de.lise.fluxflow.springboot.web.SpringWebRequestContextResolution;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/lise/fluxflow/springboot/web/SpringWebRequestBodyParameterResolution;", "Lde/lise/fluxflow/springboot/web/SpringWebRequestContextResolution;", "functionParam", "Lde/lise/fluxflow/reflection/activation/parameter/FunctionParameter;", "optional", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "targetType", "Ljava/lang/Class;", "(Lde/lise/fluxflow/reflection/activation/parameter/FunctionParameter;ZLcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/Class;)V", "get", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "springboot-web"})
public final class SpringWebRequestBodyParameterResolution
extends SpringWebRequestContextResolution {
    private final boolean optional;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Class<?> targetType;

    public SpringWebRequestBodyParameterResolution(@NotNull FunctionParameter<?> functionParam, boolean optional, @NotNull ObjectMapper objectMapper, @NotNull Class<?> targetType) {
        Intrinsics.checkNotNullParameter(functionParam, (String)"functionParam");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        super(functionParam);
        this.optional = optional;
        this.objectMapper = objectMapper;
        this.targetType = targetType;
    }

    @Override
    @Nullable
    protected Object get(@NotNull HttpServletRequest request) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            object = this.objectMapper.readValue((InputStream)request.getInputStream(), this.targetType);
        }
        catch (MismatchedInputException e) {
            if (!this.optional) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing or invalid request body. A " + this.targetType.getSimpleName() + " is required.");
            }
            object = null;
        }
        return object;
    }
}

